/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.utility;

import com.google.common.base.Objects;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import java.util.Arrays;

public class Continuum<T> {
    private final T pointA;
    private final T pointB;

    private Continuum(T pointA, T pointB) {
        this.pointA = pointA;
        this.pointB = pointB;
    }

    public static <T> Continuum<T> between(T pointA, T pointB) {
        return new Continuum<T>(pointA, pointB);
    }

    public static <C extends Comparable<? super C>> Continuum<C> over(Iterable<? extends C> iterable) {
        return Continuum.between((Comparable)Ordering.natural().min(iterable), (Comparable)Ordering.natural().max(iterable));
    }

    public static <C extends Comparable<? super C>> Continuum<C> over(C first, C ... rest) {
        return Continuum.over(Arrays.asList((Comparable[])ObjectArrays.concat(first, (Object[])rest)));
    }

    public static <C extends Comparable<? super C>> Continuum<C> fromRange(Range<C> range) {
        return Continuum.between(range.lowerEndpoint(), range.upperEndpoint());
    }

    public T getPointA() {
        return this.pointA;
    }

    public T getPointB() {
        return this.pointB;
    }

    public boolean isEmpty() {
        return Objects.equal(this.pointA, this.pointB);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (thatObject == null) {
            return false;
        }
        if (!(thatObject instanceof Continuum)) {
            return false;
        }
        Continuum that = (Continuum)thatObject;
        return Objects.equal(this.pointA, that.pointA) && Objects.equal(this.pointB, that.pointB);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pointA, this.pointB});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("pointA", this.pointA).add("pointB", this.pointB).toString();
    }
}

