/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.utility;

import com.google.common.base.Objects;

public class Dimension<T> {
    private final T width;
    private final T height;

    private Dimension(T width, T height) {
        this.width = width;
        this.height = height;
    }

    public static <T> Dimension<T> ofSize(T width, T height) {
        return new Dimension<T>(width, height);
    }

    public static <T> Dimension<T> copyOf(Dimension<T> dimension) {
        return Dimension.ofSize(dimension.width, dimension.height);
    }

    public static Dimension<Integer> fromAWTDimension(java.awt.Dimension awtDimension) {
        return Dimension.ofSize(awtDimension.width, awtDimension.height);
    }

    public static java.awt.Dimension copyAsAWTDimension(Dimension<? extends Number> dimension) {
        return new java.awt.Dimension(((Number)dimension.width).intValue(), ((Number)dimension.height).intValue());
    }

    public T getWidth() {
        return this.width;
    }

    public T getHeight() {
        return this.height;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.width, this.height});
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (thatObject == null) {
            return false;
        }
        if (!(thatObject instanceof Dimension)) {
            return false;
        }
        Dimension that = (Dimension)thatObject;
        return Objects.equal(this.width, that.width) && Objects.equal(this.height, that.height);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("width", this.width).add("height", this.height).toString();
    }
}

