/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.utility;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.iu.sci2.visualization.geomaps.utility.Iterators2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Iterables2 {
    private Iterables2() {
    }

    public static <E> Iterable<E> omitConsecutiveDuplicates(final Iterable<? extends E> iterable, final Equivalence<? super E> equivalence) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return Iterators2.omitConsecutiveDuplicates(iterable.iterator(), equivalence);
            }
        };
    }

    public static <E> List<List<E>> split(Iterable<? extends E> toSplit, Equivalence<? super E> equivalence) {
        ArrayList split = Lists.newArrayList();
        if (Iterables.isEmpty(toSplit)) {
            return split;
        }
        Object firstElement = Iterables.getFirst(toSplit, null);
        ArrayList currentPart = Lists.newArrayList((Iterable)ImmutableList.of((Object)firstElement));
        Object previousElement = firstElement;
        for (Object element : Iterables.skip(toSplit, (int)1)) {
            if (!equivalence.equivalent(element, previousElement)) {
                split.add(currentPart);
                currentPart = Lists.newArrayList();
            }
            currentPart.add(element);
            previousElement = element;
        }
        split.add(currentPart);
        return split;
    }
}

