/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.utility;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;

public class NicelyNamedEnums {
    private NicelyNamedEnums() {
    }

    public static <T extends Enum<T>> ImmutableSet<String> allNiceNamesOf(Class<T> enumClass) {
        return NicelyNamedEnums.mapNiceNamesToConstants(enumClass).keySet();
    }

    public static <T extends Enum<T>> T getConstantNamed(Class<T> clazz, String niceName) {
        Enum enumConstant = (Enum)NicelyNamedEnums.mapNiceNamesToConstants(clazz).get((Object)niceName);
        if (enumConstant == null) {
            throw new IllegalArgumentException(String.format("No enum constant from %s has the nice name \"%s\".", clazz, niceName));
        }
        return (T)enumConstant;
    }

    private static <T extends Enum<T>> ImmutableBiMap<String, T> mapNiceNamesToConstants(Class<T> enumClass) {
        return ImmutableBiMap.copyOf((Map)Maps.uniqueIndex(EnumSet.allOf(enumClass), (Function)new Function<NicelyNamed, String>(){

            public String apply(NicelyNamed n) {
                return n.getNiceName();
            }
        }));
    }

    public static interface NicelyNamed {
        public String getNiceName();
    }
}

