/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.utility;

import com.google.common.base.Equivalence;

public class RelativeDifferences {
    public static final double DEFAULT_RELATIVE_DIFFERENCE_TOLERANCE = 0.01;
    public static final Equivalence<Double> DEFAULT_EQUIVALENCE = RelativeDifferences.equivalenceUpToTolerance(0.01);

    private RelativeDifferences() {
    }

    public static Equivalence<Double> equivalenceUpToTolerance(final double tolerance) {
        return new Equivalence<Double>(){

            protected boolean doEquivalent(Double a, Double b) {
                return RelativeDifferences.nearlyEqual(a, b, tolerance);
            }

            protected int doHash(Double t) {
                return 0;
            }
        };
    }

    public static double relativeDifference(double d1, double d2) {
        return d1 == d2 ? 0.0 : Math.abs(d1 - d2) / Math.max(Math.abs(d1), Math.abs(d2));
    }

    public static boolean nearlyEqual(double d1, double d2) {
        return RelativeDifferences.nearlyEqual(d1, d2, 0.01);
    }

    public static boolean nearlyEqual(double d1, double d2, double tolerance) {
        return RelativeDifferences.relativeDifference(d1, d2) <= tolerance;
    }
}

