/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.utility;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import edu.iu.sci2.visualization.geomaps.utility.Lists2;
import edu.iu.sci2.visualization.geomaps.utility.StringPredicates;
import java.util.Comparator;
import java.util.List;
import org.cishell.utilities.ToCaseFunction;

public class SubstringOrderings {
    private SubstringOrderings() {
    }

    public static Ordering<String> explicit(final List<? extends String> candidateSubstringsInOrder) {
        Function<String, Integer> rankFunction = new Function<String, Integer>(){

            public Integer apply(String string) {
                return Lists2.lastIndexOf(candidateSubstringsInOrder, StringPredicates.substringOf(string, (Function<? super String, ? extends String>)ToCaseFunction.LOWER));
            }
        };
        Ordering bySubstringRank = Ordering.natural().onResultOf((Function)rankFunction);
        return bySubstringRank.compound((Comparator)Ordering.natural());
    }

    public static Ordering<String> explicit(String leastCandidateSubstring, String ... remainingCandidateSubstringsInOrder) {
        return SubstringOrderings.explicit(Lists.asList((Object)leastCandidateSubstring, (Object[])remainingCandidateSubstringsInOrder));
    }
}

