/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.utility.numberformat;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import com.google.common.primitives.Doubles;
import edu.iu.sci2.visualization.geomaps.utility.RelativeDifferences;
import edu.iu.sci2.visualization.geomaps.utility.StringPredicates;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.UnsignedZeroFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.cishell.utilities.ToCaseFunction;

public class NumberFormatFactory {
    public static final int ATTEMPT_LIMIT = 8;

    public static UnsignedZeroFormat getNumberFormat(NumericFormatType numericFormatType, double ... values) {
        DecimalFormat baseFormat = new DecimalFormat();
        if (numericFormatType.equals((Object)NumericFormatType.YEAR)) {
            ((NumberFormat)baseFormat).setGroupingUsed(false);
        }
        NumberFormatFactory.setFormatPrecision(baseFormat, values);
        return UnsignedZeroFormat.wrapping(baseFormat);
    }

    private static void setFormatPrecision(NumberFormat formatter, double ... values) {
        int maximumNumberOfFractionDigits = 0;
        int _attempt = 0;
        while (_attempt < 8) {
            formatter.setMaximumFractionDigits(maximumNumberOfFractionDigits);
            double[] approximateValues = new double[values.length];
            int ii = 0;
            while (ii < values.length) {
                try {
                    approximateValues[ii] = formatter.parse(formatter.format(values[ii])).doubleValue();
                }
                catch (ParseException e) {
                    throw new RuntimeException("Failed to parse formatter result.", e);
                }
                ++ii;
            }
            if (Ordering.natural().isStrictlyOrdered((Iterable)Doubles.asList((double[])approximateValues)) && RelativeDifferences.DEFAULT_EQUIVALENCE.pairwise().equivalent((Object)Doubles.asList((double[])values), (Object)Doubles.asList((double[])approximateValues))) break;
            ++maximumNumberOfFractionDigits;
            ++_attempt;
        }
    }

    public static enum NumericFormatType {
        YEAR,
        GENERAL;

        private static final Range<Double> TYPICAL_YEAR_RANGE;

        static {
            TYPICAL_YEAR_RANGE = Ranges.closed((Comparable)Double.valueOf(1200.0), (Comparable)Double.valueOf(3000.0));
        }

        public static NumericFormatType guessFor(String columnName, Range<Double> range) {
            if (columnName == null || range == null) {
                return GENERAL;
            }
            if (NumericFormatType.isColumnNameYearish(columnName) && NumericFormatType.isRangeYearish(range)) {
                return YEAR;
            }
            return GENERAL;
        }

        private static boolean isRangeYearish(Range<Double> range) {
            return TYPICAL_YEAR_RANGE.encloses(range);
        }

        private static boolean isColumnNameYearish(String string) {
            return Iterables.any((Iterable)ImmutableSet.of((Object)"year", (Object)"yr", (Object)"date", (Object)"time"), StringPredicates.substringOf(string, (Function<? super String, ? extends String>)ToCaseFunction.LOWER));
        }
    }
}

