/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.utility.numberformat;

import com.google.common.base.Objects;
import java.text.Format;

public class UnsignedZeroFormat {
    public static final String UNSIGNED_ZERO = "0";
    public static final String NEGATIVE_ZERO = "-0";
    private final Format format;

    private UnsignedZeroFormat(Format formatter) {
        this.format = formatter;
    }

    public static UnsignedZeroFormat wrapping(Format formatter) {
        return new UnsignedZeroFormat(formatter);
    }

    public String format(double value) {
        String result = this.format.format(value);
        return NEGATIVE_ZERO.equals(result) ? UNSIGNED_ZERO : result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("format", (Object)this.format).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.format});
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (thatObject == null) {
            return false;
        }
        if (!(thatObject instanceof UnsignedZeroFormat)) {
            return false;
        }
        UnsignedZeroFormat that = (UnsignedZeroFormat)thatObject;
        return Objects.equal((Object)this.format, (Object)that.format);
    }
}

