/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.iu.sci2.visualization.geomaps.GeoMapsNetworkFactory;
import edu.iu.sci2.visualization.geomaps.data.GeoDataset;
import edu.iu.sci2.visualization.geomaps.geo.projection.KnownProjectedCRSDescriptor;
import edu.iu.sci2.visualization.geomaps.geo.shapefiles.Shapefile;
import edu.iu.sci2.visualization.geomaps.utility.NicelyNamedEnums;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.NumberFormatFactory;
import edu.iu.sci2.visualization.geomaps.viz.Circle;
import edu.iu.sci2.visualization.geomaps.viz.FeatureView;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import edu.iu.sci2.visualization.geomaps.viz.coding.Coding;
import edu.iu.sci2.visualization.geomaps.viz.legend.LabeledReference;
import edu.iu.sci2.visualization.geomaps.viz.legend.LegendCreationException;
import edu.iu.sci2.visualization.geomaps.viz.model.GeoMap;
import edu.iu.sci2.visualization.geomaps.viz.model.GeoMapException;
import edu.iu.sci2.visualization.geomaps.viz.ps.HowToRead;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import prefuse.data.Table;
import prefuse.data.Tuple;

public abstract class AnnotationMode<G, D extends Enum<D>> {
    protected abstract EnumSet<D> dimensions();

    protected abstract GeoDataset<G, D> readTable(Table var1, Collection<VizDimension.Binding<D>> var2);

    protected abstract Collection<Circle> makeCircles(GeoDataset<G, D> var1, Collection<? extends Coding<D>> var2);

    protected abstract Collection<FeatureView> makeFeatureViews(GeoDataset<G, D> var1, Collection<? extends Coding<D>> var2);

    public GeoMap createGeoMap(Table table, Dictionary<String, Object> parameters, PageLayout pageLayout, String title, String subtitle, StringTemplate templateForHowToRead) throws LegendCreationException, GeoMapException {
        Shapefile shapefile = NicelyNamedEnums.getConstantNamed(Shapefile.class, (String)parameters.get(GeoMapsNetworkFactory.Parameter.SHAPEFILE_KEY.id()));
        KnownProjectedCRSDescriptor knownProjectedCRSDescriptor = shapefile.getDefaultProjectedCrs();
        String projection = (String)parameters.get("projection");
        if (projection != null) {
            knownProjectedCRSDescriptor = NicelyNamedEnums.getConstantNamed(KnownProjectedCRSDescriptor.class, projection);
        }
        Collection<VizDimension.Binding<D>> enabledBindings = this.bindTo(parameters);
        GeoDataset<G, D> usableData = this.readTable(table, enabledBindings);
        HashSet codings = Sets.newHashSet();
        ArrayList legends = Lists.newArrayList();
        for (VizDimension.Binding<D> binding : enabledBindings) {
            NumberFormatFactory.NumericFormatType numericFormatType = NumberFormatFactory.NumericFormatType.guessFor(binding.columnName(), usableData.calculateRangeOver(binding.dimension(), GeoDataset.Stage.SCALABLE));
            Coding<D> coding = binding.codingForDataRange(usableData.calculateRangeOver(binding.dimension(), GeoDataset.Stage.SCALABLE), usableData.calculateRangeOver(binding.dimension(), GeoDataset.Stage.SCALED), shapefile);
            codings.add(coding);
            LabeledReference legend = coding.makeLabeledReference(pageLayout, numericFormatType);
            legends.add(legend);
        }
        Optional howToRead = Optional.absent();
        if (pageLayout.howToReadLowerLeft().isPresent()) {
            String mapKind = subtitle.toLowerCase();
            templateForHowToRead.setAttributes((Map)ImmutableMap.of((Object)"mapKind", (Object)mapKind, (Object)"baseMapDescription", (Object)shapefile.makeMapDescription(), (Object)"projectionName", (Object)knownProjectedCRSDescriptor.getDescription(), (Object)"hasInsets", (Object)shapefile.hasInsets(), (Object)"partType", (Object)shapefile.getComponentDescriptionPlain()));
            String howToReadText = templateForHowToRead.toString().trim();
            howToRead = Optional.of((Object)new HowToRead((Point2D.Double)pageLayout.howToReadLowerLeft().get(), pageLayout, howToReadText, mapKind));
        }
        return new GeoMap(title, shapefile, knownProjectedCRSDescriptor, this.makeFeatureViews(usableData, codings), this.makeCircles(usableData, codings), legends, pageLayout, (Optional<HowToRead>)howToRead);
    }

    private Collection<VizDimension.Binding<D>> bindTo(final Dictionary<String, Object> parameters) {
        return Collections2.filter((Collection)Collections2.transform(this.dimensions(), (Function)new Function<D, VizDimension.Binding<D>>(){

            public VizDimension.Binding<D> apply(D dimension) {
                return ((VizDimension)dimension).bindingFor(parameters);
            }
        }), (Predicate)new Predicate<VizDimension.Binding<D>>(){

            public boolean apply(VizDimension.Binding<D> binding) {
                return binding.isEnabled();
            }
        });
    }

    public static class GeoIdentifierException
    extends Exception {
        private static final long serialVersionUID = 2920164548741550342L;

        public GeoIdentifierException(String message) {
            super(message);
        }
    }

    public static interface GeoIdentifierReader<G> {
        public G readFrom(Tuple var1) throws GeoIdentifierException;
    }
}

