/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import edu.iu.sci2.visualization.geomaps.utility.Continuum;
import edu.iu.sci2.visualization.geomaps.viz.CircleDimension;
import edu.iu.sci2.visualization.geomaps.viz.model.GeoMap;
import edu.iu.sci2.visualization.geomaps.viz.ps.GeoMapViewPageArea;
import edu.iu.sci2.visualization.geomaps.viz.strategy.CircleAreaStrategy;
import edu.iu.sci2.visualization.geomaps.viz.strategy.Strategy;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.EnumMap;
import org.opengis.referencing.operation.TransformException;

public class Circle {
    private final Coordinate coordinate;
    private final EnumMap<CircleDimension, Strategy> strategies;
    public static final Continuum<Double> DEFAULT_CIRCLE_RADIUS_CONTINUUM = Continuum.between(0.72, 24.48);
    public static final Continuum<Double> DEFAULT_CIRCLE_AREA_CONTINUUM = Continuum.between(Circle.calculateAreaFromRadius(DEFAULT_CIRCLE_RADIUS_CONTINUUM.getPointA()), Circle.calculateAreaFromRadius(DEFAULT_CIRCLE_RADIUS_CONTINUUM.getPointB()));
    public static final double DEFAULT_CIRCLE_AREA = 0.005 * DEFAULT_CIRCLE_AREA_CONTINUUM.getPointB();
    public static final double DEFAULT_CIRCLE_LINE_WIDTH = 1.5;
    public static final double OUTLINE_ADDITIONAL_RADIUS = 0.8;
    public static final Color DEFAULT_OUTLINE_COLOR = Color.BLACK;

    public Circle(Coordinate coordinate, EnumMap<CircleDimension, Strategy> strategies) {
        this.coordinate = coordinate;
        this.strategies = strategies;
    }

    public String toPostScript(GeoMap geoMap, GeoMapViewPageArea geoMapViewPageArea) throws TransformException {
        CircleAreaStrategy areaStrategy = (CircleAreaStrategy)this.strategyFor(CircleDimension.AREA);
        double radius = Circle.calculateRadiusFromArea(areaStrategy.getArea());
        Strategy innerColorStrategy = this.strategyFor(CircleDimension.INNER_COLOR);
        Strategy outerColorStrategy = this.strategyFor(CircleDimension.OUTER_COLOR);
        StringBuilder builder = new StringBuilder();
        for (Point projectedPoint : geoMap.transformAndInset(this.coordinate)) {
            Point2D.Double displayPoint = geoMapViewPageArea.displayPointFor(projectedPoint.getCoordinate());
            double outlineRadius = radius + 0.8;
            builder.append("    " + displayPoint.x + " " + displayPoint.y + " " + outlineRadius + " circle" + "\n");
            builder.append(outerColorStrategy.toPostScript());
            builder.append("    " + displayPoint.x + " " + displayPoint.y + " " + radius + " circle" + "\n");
            builder.append(innerColorStrategy.toPostScript());
            builder.append('\n');
        }
        return builder.toString();
    }

    public Strategy strategyFor(CircleDimension dimension) {
        if (this.strategies.containsKey(dimension)) {
            return this.strategies.get(dimension);
        }
        return dimension.defaultStrategy();
    }

    public static double calculateAreaFromRadius(double radius) {
        return Math.PI * radius * radius;
    }

    public static double calculateRadiusFromArea(double area) {
        return Math.sqrt(area / Math.PI);
    }
}

