/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import edu.iu.sci2.visualization.geomaps.data.interpolation.ColorInterpolator;
import edu.iu.sci2.visualization.geomaps.data.interpolation.Interpolator;
import edu.iu.sci2.visualization.geomaps.data.interpolation.Interpolator1D;
import edu.iu.sci2.visualization.geomaps.data.scaling.Scaling;
import edu.iu.sci2.visualization.geomaps.data.scaling.ScalingException;
import edu.iu.sci2.visualization.geomaps.geo.shapefiles.Shapefile;
import edu.iu.sci2.visualization.geomaps.utility.Averages;
import edu.iu.sci2.visualization.geomaps.utility.Continuum;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.NumberFormatFactory;
import edu.iu.sci2.visualization.geomaps.viz.Circle;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import edu.iu.sci2.visualization.geomaps.viz.coding.AbstractCoding;
import edu.iu.sci2.visualization.geomaps.viz.coding.AbstractColorCoding;
import edu.iu.sci2.visualization.geomaps.viz.coding.Coding;
import edu.iu.sci2.visualization.geomaps.viz.legend.AreaLegend;
import edu.iu.sci2.visualization.geomaps.viz.legend.LabeledReference;
import edu.iu.sci2.visualization.geomaps.viz.legend.LegendCreationException;
import edu.iu.sci2.visualization.geomaps.viz.legend.VizLegendModel;
import edu.iu.sci2.visualization.geomaps.viz.ps.LabeledReferenceCircles;
import edu.iu.sci2.visualization.geomaps.viz.strategy.CircleAreaStrategy;
import edu.iu.sci2.visualization.geomaps.viz.strategy.FillColorStrategy;
import edu.iu.sci2.visualization.geomaps.viz.strategy.Strategy;
import edu.iu.sci2.visualization.geomaps.viz.strategy.StrokeColorStrategy;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.List;
import org.cishell.utilities.mutateParameter.dropdown.DropdownMutator;

public enum CircleDimension implements VizDimension
{
    AREA("circleAreaColumnName", "None (uniform sizes)", "circleAreaScaling", null){

        @Override
        public Strategy defaultStrategy() {
            return CircleAreaStrategy.forArea(Circle.DEFAULT_CIRCLE_AREA);
        }

        @Override
        public VizDimension.Binding<CircleDimension> bindingFor(Dictionary<String, Object> parameters) {
            return new VizDimension.Binding<CircleDimension>((CircleDimension)this, parameters){

                @Override
                public Coding<CircleDimension> codingForDataRange(Range<Double> scalableRange, final Range<Double> scaledRange, Shapefile shapefile) {
                    Continuum<Double> sizeContinuum = Circle.DEFAULT_CIRCLE_AREA_CONTINUUM;
                    Range scaledRangeFromZero = Ranges.closed((Comparable)Double.valueOf(0.0), (Comparable)((Double)scaledRange.upperEndpoint()));
                    final Interpolator1D interpolator = Interpolator1D.between((Range<Double>)scaledRangeFromZero, sizeContinuum);
                    double minDataCircleSize = (Double)interpolator.apply((Double)scaledRange.lowerEndpoint());
                    Continuum<Double> legendContinuum = Continuum.between(minDataCircleSize, sizeContinuum.getPointB());
                    return new AbstractCoding<CircleDimension, Double>((VizDimension.Binding)this, scalableRange, legendContinuum){

                        @Override
                        public Strategy strategyForValue(double value) {
                            return CircleAreaStrategy.forArea((Double)interpolator.apply(value));
                        }

                        @Override
                        public String legendDescription() {
                            return "Area";
                        }

                        @Override
                        public LabeledReference makeLabeledReference(PageLayout pageLayout, NumberFormatFactory.NumericFormatType numericFormatType) throws LegendCreationException {
                            VizLegendModel<Double> generalLegend = this.makeVizLegend(numericFormatType);
                            try {
                                double midpointOfScaledData = Averages.meanOfDoubles((Double)scaledRange.lowerEndpoint(), (Double)scaledRange.upperEndpoint());
                                double unscaledValueForMidrangeArea = this.scaling().invert(midpointOfScaledData);
                                double midrangeArea = (Double)interpolator.apply(midpointOfScaledData);
                                AreaLegend areaLegend = new AreaLegend(generalLegend, unscaledValueForMidrangeArea, midrangeArea);
                                return new LabeledReferenceCircles(areaLegend, new Point2D.Double(pageLayout.legendariumLowerLeft().getX() + 2.0 * pageLayout.legendariumReservedDimensions().getWidth() / (double)EnumSet.allOf(CircleDimension.class).size(), pageLayout.legendLowerLeft().getY()), pageLayout);
                            }
                            catch (ScalingException e) {
                                throw new LegendCreationException("Problem formatting numbers for legend.", e);
                            }
                        }
                    };
                }
            };
        }
    }
    ,
    OUTER_COLOR("outerColorColumnName", "None (uniform coloring)", "outerColorScaling", "outerColorRange"){

        @Override
        public void addOptionsToAlgorithmParameters(DropdownMutator mutator, List<String> numericColumnNames) {
            super.addOptionsToAlgorithmParameters(mutator, numericColumnNames);
            2.addColorRangeParameter(mutator, this.getRangeParameterId());
        }

        @Override
        public Strategy defaultStrategy() {
            return StrokeColorStrategy.theDefault();
        }

        @Override
        public VizDimension.Binding<CircleDimension> bindingFor(final Dictionary<String, Object> parameters) {
            return new VizDimension.Binding<CircleDimension>((CircleDimension)this, parameters){

                @Override
                public Coding<CircleDimension> codingForDataRange(Range<Double> usableRange, Range<Double> dataRange, Shapefile shapefile) {
                    Continuum colorContinuum = (Continuum)AbstractColorCoding.COLOR_CONTINUUMS.get(parameters.get(this.getRangeParameterId()));
                    final ColorInterpolator interpolator = ColorInterpolator.between(dataRange, colorContinuum);
                    return new AbstractColorCoding<CircleDimension>((VizDimension.Binding)this, usableRange, (Interpolator)interpolator){

                        @Override
                        public Strategy strategyForValue(double value) {
                            return StrokeColorStrategy.forColor((Color)interpolator.apply(value));
                        }

                        @Override
                        public String legendDescription() {
                            return "Exterior Color";
                        }

                        @Override
                        public Point2D.Double lowerLeft(PageLayout pageLayout) {
                            return new Point2D.Double(pageLayout.legendariumLowerLeft().getX() + 1.0 * pageLayout.legendariumReservedDimensions().getWidth() / (double)EnumSet.allOf(CircleDimension.class).size(), pageLayout.legendLowerLeft().getY());
                        }
                    };
                }
            };
        }
    }
    ,
    INNER_COLOR("innerColorColumnName", "None (no coloring)", "innerColorScaling", "innerColorRange"){

        @Override
        public void addOptionsToAlgorithmParameters(DropdownMutator mutator, List<String> numericColumnNames) {
            super.addOptionsToAlgorithmParameters(mutator, numericColumnNames);
            3.addColorRangeParameter(mutator, this.getRangeParameterId());
        }

        @Override
        public Strategy defaultStrategy() {
            return FillColorStrategy.forColor(null);
        }

        @Override
        public VizDimension.Binding<CircleDimension> bindingFor(final Dictionary<String, Object> parameters) {
            return new VizDimension.Binding<CircleDimension>((CircleDimension)this, parameters){

                @Override
                public Coding<CircleDimension> codingForDataRange(Range<Double> usableRange, Range<Double> dataRange, Shapefile shapefile) {
                    Continuum colorContinuum = (Continuum)AbstractColorCoding.COLOR_CONTINUUMS.get(parameters.get(this.getRangeParameterId()));
                    final ColorInterpolator interpolator = ColorInterpolator.between(dataRange, colorContinuum);
                    return new AbstractColorCoding<CircleDimension>((VizDimension.Binding)this, usableRange, (Interpolator)interpolator){

                        @Override
                        public Strategy strategyForValue(double value) {
                            return FillColorStrategy.forColor((Color)interpolator.apply(value));
                        }

                        @Override
                        public String legendDescription() {
                            return "Interior Color";
                        }

                        @Override
                        public Point2D.Double lowerLeft(PageLayout pageLayout) {
                            return new Point2D.Double(pageLayout.legendariumLowerLeft().getX() + 0.0 * pageLayout.legendariumReservedDimensions().getWidth() / (double)EnumSet.allOf(CircleDimension.class).size(), pageLayout.legendLowerLeft().getY());
                        }
                    };
                }
            };
        }
    };

    private String columnNameParameterId;
    private String columnNameParameterDisablingToken;
    private String scalingParameterId;
    private String rangeParameterId;

    private CircleDimension(String columnNameParameterId, String columnNameParameterDisablingToken, String scalingParameterId, String rangeParameterId) {
        this.columnNameParameterId = columnNameParameterId;
        this.columnNameParameterDisablingToken = columnNameParameterDisablingToken;
        this.scalingParameterId = scalingParameterId;
        this.rangeParameterId = rangeParameterId;
    }

    public abstract VizDimension.Binding<CircleDimension> bindingFor(Dictionary<String, Object> var1);

    @Override
    public abstract Strategy defaultStrategy();

    @Override
    public String getColumnNameParameterId() {
        return this.columnNameParameterId;
    }

    @Override
    public String getColumnNameParameterDisablingToken() {
        return this.columnNameParameterDisablingToken;
    }

    @Override
    public String getScalingParameterId() {
        return this.scalingParameterId;
    }

    @Override
    public String getRangeParameterId() {
        return this.rangeParameterId;
    }

    @Override
    public void addOptionsToAlgorithmParameters(DropdownMutator mutator, List<String> numericColumnNames) {
        ArrayList options = Lists.newArrayList(numericColumnNames);
        options.add(this.getColumnNameParameterDisablingToken());
        mutator.add(this.getColumnNameParameterId(), (Collection)options, this.getColumnNameParameterDisablingToken());
        mutator.add(this.getScalingParameterId(), Collections2.transform(EnumSet.allOf(Scaling.class), (Function)Functions.toStringFunction()));
    }

    public static void addColorRangeParameter(DropdownMutator mutator, String parameterId) {
        mutator.add(parameterId, (Collection)Lists.newArrayList((Iterable)AbstractColorCoding.COLOR_CONTINUUMS.keySet()));
    }

    /* synthetic */ CircleDimension(String string, int n, String string2, String string3, String string4, String string5, CircleDimension circleDimension) {
        this(string2, string3, string4, string5);
    }
}

