/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import edu.iu.sci2.visualization.geomaps.data.interpolation.ColorInterpolator;
import edu.iu.sci2.visualization.geomaps.data.interpolation.Interpolator;
import edu.iu.sci2.visualization.geomaps.data.scaling.Scaling;
import edu.iu.sci2.visualization.geomaps.geo.shapefiles.Shapefile;
import edu.iu.sci2.visualization.geomaps.utility.Continuum;
import edu.iu.sci2.visualization.geomaps.viz.CircleDimension;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import edu.iu.sci2.visualization.geomaps.viz.coding.AbstractColorCoding;
import edu.iu.sci2.visualization.geomaps.viz.coding.Coding;
import edu.iu.sci2.visualization.geomaps.viz.strategy.FillColorStrategy;
import edu.iu.sci2.visualization.geomaps.viz.strategy.Strategy;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.List;
import org.cishell.utilities.mutateParameter.dropdown.DropdownMutator;

public enum FeatureDimension implements VizDimension
{
    REGION_COLOR("featureColorColumnName", "None (uniform coloring)", "featureColorScaling", "featureColorRange"){

        @Override
        public void addOptionsToAlgorithmParameters(DropdownMutator mutator, List<String> numericColumnNames) {
            super.addOptionsToAlgorithmParameters(mutator, numericColumnNames);
            CircleDimension.addColorRangeParameter(mutator, this.getRangeParameterId());
        }

        @Override
        public Strategy defaultStrategy() {
            return FillColorStrategy.forColor(Color.GRAY);
        }

        @Override
        public VizDimension.Binding<FeatureDimension> bindingFor(final Dictionary<String, Object> parameters) {
            return new VizDimension.Binding<FeatureDimension>((FeatureDimension)this, parameters){

                @Override
                public Coding<FeatureDimension> codingForDataRange(Range<Double> usableRange, Range<Double> dataRange, final Shapefile shapefile) {
                    Continuum colorContinuum = (Continuum)AbstractColorCoding.COLOR_CONTINUUMS.get(parameters.get(this.getRangeParameterId()));
                    final ColorInterpolator interpolator = ColorInterpolator.between(dataRange, colorContinuum);
                    return new AbstractColorCoding<FeatureDimension>((VizDimension.Binding)this, usableRange, (Interpolator)interpolator){

                        @Override
                        public Strategy strategyForValue(double value) {
                            return FillColorStrategy.forColor((Color)interpolator.apply(value));
                        }

                        @Override
                        public String legendDescription() {
                            return String.format("%s Color", shapefile.getComponentDescriptionTitleCase());
                        }

                        @Override
                        public Point2D.Double lowerLeft(PageLayout pageLayout) {
                            return pageLayout.legendLowerLeft();
                        }
                    };
                }
            };
        }
    };

    private String columnNameParameterId;
    private String columnNameParameterDisablingToken;
    private String scalingParameterId;
    private String rangeParameterId;

    private FeatureDimension(String columnNameParameterId, String columnNameParameterDisablingToken, String scalingParameterId, String rangeParameterId) {
        this.columnNameParameterId = columnNameParameterId;
        this.columnNameParameterDisablingToken = columnNameParameterDisablingToken;
        this.scalingParameterId = scalingParameterId;
        this.rangeParameterId = rangeParameterId;
    }

    @Override
    public abstract Strategy defaultStrategy();

    public abstract VizDimension.Binding<FeatureDimension> bindingFor(Dictionary<String, Object> var1);

    @Override
    public String getColumnNameParameterId() {
        return this.columnNameParameterId;
    }

    @Override
    public String getColumnNameParameterDisablingToken() {
        return this.columnNameParameterDisablingToken;
    }

    @Override
    public String getScalingParameterId() {
        return this.scalingParameterId;
    }

    @Override
    public String getRangeParameterId() {
        return this.rangeParameterId;
    }

    @Override
    public void addOptionsToAlgorithmParameters(DropdownMutator mutator, List<String> numericColumnNames) {
        ArrayList options = Lists.newArrayList(numericColumnNames);
        options.add(this.getColumnNameParameterDisablingToken());
        mutator.add(this.getColumnNameParameterId(), (Collection)options, this.getColumnNameParameterDisablingToken());
        mutator.add(this.getScalingParameterId(), Collections2.transform(EnumSet.allOf(Scaling.class), (Function)Functions.toStringFunction()));
    }

    /* synthetic */ FeatureDimension(String string, int n, String string2, String string3, String string4, String string5, FeatureDimension featureDimension) {
        this(string2, string3, string4, string5);
    }
}

