/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz;

import com.google.common.base.Optional;
import edu.iu.sci2.visualization.geomaps.utility.Dimension;
import edu.iu.sci2.visualization.geomaps.utility.Rectangles;
import edu.iu.sci2.visualization.geomaps.viz.Circle;
import edu.iu.sci2.visualization.geomaps.viz.CircleDimension;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;

public enum PageLayout {
    WEB{

        @Override
        public Dimension<Double> pageDimensions() {
            return Dimension.ofSize(1280.16, 959.76);
        }

        @Override
        public Optional<Point2D.Double> headerLowerLeft() {
            return Optional.absent();
        }

        @Override
        public double headerHeight() {
            return this.pageMargin();
        }

        @Override
        public Optional<Point2D.Double> howToReadLowerLeft() {
            return Optional.absent();
        }

        @Override
        public Font titleFont() {
            return new Font("Arial", 1, 20);
        }

        @Override
        public Font contentFont() {
            return new Font("Arial", 0, 16);
        }

        @Override
        public double pageMargin() {
            return 18.0;
        }
    }
    ,
    PRINT{

        @Override
        public Dimension<Double> pageDimensions() {
            return Dimension.ofSize(792.0, 612.0);
        }

        @Override
        public Optional<Point2D.Double> headerLowerLeft() {
            return Optional.of((Object)new Point2D.Double(this.pageMargin(), this.pageDimensions().getHeight() - this.pageMargin() - (double)this.titleFont().getSize()));
        }

        @Override
        public double headerHeight() {
            return 0.15 * this.pageDimensions().getHeight();
        }

        @Override
        public Optional<Point2D.Double> howToReadLowerLeft() {
            return Optional.of((Object)new Point2D.Double(0.55 * this.pageDimensions().getWidth(), this.legendariumLowerLeft().getY()));
        }

        @Override
        public Font titleFont() {
            return new Font("Arial", 1, 14);
        }

        @Override
        public Font contentFont() {
            return new Font("Arial", 0, 10);
        }

        @Override
        public double pageMargin() {
            return 18.0;
        }
    };

    public static final double POINTS_PER_INCH = 72.0;
    private static final double COLOR_GRADIENT_HEIGHT = 10.0;

    private PageLayout() {
    }

    public abstract Dimension<Double> pageDimensions();

    public abstract double pageMargin();

    public abstract Font titleFont();

    public abstract Font contentFont();

    public abstract Optional<Point2D.Double> headerLowerLeft();

    public abstract double headerHeight();

    public abstract Optional<Point2D.Double> howToReadLowerLeft();

    public Dimension<Double> mapPageAreaMaxDimensions() {
        return Dimension.ofSize(this.pageDimensions().getWidth() - 2.0 * this.pageMargin(), this.pageDimensions().getHeight() - (this.headerHeight() + this.legendariumReservedDimensions().getHeight() + 2.0 * this.pageMargin()));
    }

    public double pageFooterHeight() {
        return this.pageMargin() + 18.0;
    }

    public double mapCenterX() {
        return this.pageDimensions().getWidth() / 2.0;
    }

    public Dimension<Double> legendariumReservedDimensions() {
        return Dimension.ofSize(0.6 * this.pageDimensions().getWidth(), 1.4 * (double)(this.titleFont().getSize() + 2 * this.contentFont().getSize()) + Math.max(10.0 + 1.4 * (double)this.contentFont().getSize(), 2.0 * Circle.DEFAULT_CIRCLE_RADIUS_CONTINUUM.getPointB()));
    }

    public Point2D.Double legendariumLowerLeft() {
        return new Point2D.Double(this.pageMargin(), this.pageMargin() + this.legendariumReservedDimensions().getHeight());
    }

    public Point2D.Double legendLowerLeft() {
        return new Point2D.Double(this.legendariumLowerLeft().x, this.legendariumLowerLeft().y - (double)this.titleFont().getSize());
    }

    public Dimension<Double> colorGradientDimensions() {
        return Dimension.ofSize(0.8 * (this.legendariumReservedDimensions().getWidth() / (double)EnumSet.allOf(CircleDimension.class).size()), 10.0);
    }

    public Optional<Double> howToReadWidth() {
        if (this.howToReadLowerLeft().isPresent()) {
            return Optional.of((Object)(this.pageDimensions().getWidth() - ((Point2D.Double)this.howToReadLowerLeft().get()).getX() - this.pageMargin()));
        }
        return Optional.absent();
    }

    public Rectangle2D.Double calculateMapRectangle(Rectangle2D.Double dataRectangle) {
        double availableMapHeight = this.mapPageAreaMaxDimensions().getHeight();
        double mapCenterY = this.pageFooterHeight() + this.legendariumReservedDimensions().getHeight() + availableMapHeight / 2.0;
        Point2D.Double displayCenter = new Point2D.Double(this.mapCenterX(), mapCenterY);
        double xScale = this.mapPageAreaMaxDimensions().getWidth() / dataRectangle.getWidth();
        double yScale = this.mapPageAreaMaxDimensions().getHeight() / dataRectangle.getHeight();
        double scale = Math.min(xScale, yScale);
        Dimension<Double> displayDimension = Dimension.ofSize(scale * dataRectangle.getWidth(), scale * dataRectangle.getHeight());
        return Rectangles.forCenterWithDimensions(displayCenter, displayDimension);
    }

    /* synthetic */ PageLayout(String string, int n, PageLayout pageLayout) {
        this();
    }
}

