/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz;

import com.google.common.base.Objects;
import com.google.common.collect.Range;
import edu.iu.sci2.visualization.geomaps.data.GeoDatum;
import edu.iu.sci2.visualization.geomaps.data.scaling.Scaling;
import edu.iu.sci2.visualization.geomaps.data.scaling.ScalingException;
import edu.iu.sci2.visualization.geomaps.geo.shapefiles.Shapefile;
import edu.iu.sci2.visualization.geomaps.viz.coding.Coding;
import edu.iu.sci2.visualization.geomaps.viz.strategy.Strategy;
import java.util.Dictionary;
import java.util.List;
import org.cishell.utilities.mutateParameter.dropdown.DropdownMutator;

public interface VizDimension {
    public String getColumnNameParameterId();

    public String getColumnNameParameterDisablingToken();

    public String getScalingParameterId();

    public String getRangeParameterId();

    public Strategy defaultStrategy();

    public Binding<? extends VizDimension> bindingFor(Dictionary<String, Object> var1);

    public void addOptionsToAlgorithmParameters(DropdownMutator var1, List<String> var2);

    public static abstract class Binding<D extends Enum<D>> {
        private final D dimension;
        private final String columnName;
        private final Scaling scaling;

        protected Binding(D dimension, Dictionary<String, Object> parameters) {
            this.dimension = dimension;
            this.columnName = (String)parameters.get(((VizDimension)dimension).getColumnNameParameterId());
            this.scaling = Scaling.valueOf((String)parameters.get(((VizDimension)dimension).getScalingParameterId()));
        }

        public abstract Coding<D> codingForDataRange(Range<Double> var1, Range<Double> var2, Shapefile var3);

        public D dimension() {
            return this.dimension;
        }

        public String columnName() {
            return this.columnName;
        }

        public Scaling scaling() {
            return this.scaling;
        }

        public boolean isEnabled() {
            return !Objects.equal((Object)this.columnName, (Object)((VizDimension)this.dimension).getColumnNameParameterDisablingToken());
        }

        public <G> boolean isScalable(GeoDatum<G, D> geoDatum) {
            return this.scaling().isScalable(geoDatum.valueInDimension(this.dimension()));
        }

        public <G> double scale(GeoDatum<G, D> geoDatum) throws ScalingException {
            return this.scaling().scale(geoDatum.valueInDimension(this.dimension()));
        }
    }
}

