/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.coding;

import com.google.common.collect.Range;
import edu.iu.sci2.visualization.geomaps.data.scaling.Scaling;
import edu.iu.sci2.visualization.geomaps.utility.Continuum;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.NumberFormatFactory;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import edu.iu.sci2.visualization.geomaps.viz.coding.Coding;
import edu.iu.sci2.visualization.geomaps.viz.legend.LabeledReference;
import edu.iu.sci2.visualization.geomaps.viz.legend.LegendCreationException;
import edu.iu.sci2.visualization.geomaps.viz.legend.VizLegendModel;
import edu.iu.sci2.visualization.geomaps.viz.strategy.Strategy;

public abstract class AbstractCoding<D extends Enum<D>, V>
implements Coding<D> {
    private final VizDimension.Binding<D> binding;
    private final Range<Double> usableRange;
    private final Continuum<V> vizContinuum;

    protected AbstractCoding(VizDimension.Binding<D> binding, Range<Double> usableRange, Continuum<V> vizContinuum) {
        this.binding = binding;
        this.usableRange = usableRange;
        this.vizContinuum = vizContinuum;
    }

    @Override
    public abstract Strategy strategyForValue(double var1);

    @Override
    public abstract LabeledReference makeLabeledReference(PageLayout var1, NumberFormatFactory.NumericFormatType var2) throws LegendCreationException;

    public abstract String legendDescription();

    public VizLegendModel<V> makeVizLegend(NumberFormatFactory.NumericFormatType numericFormatType) {
        return new VizLegendModel<V>(this.usableRange, this.vizContinuum, this.scaling().toString(), this.legendDescription(), this.columnName(), numericFormatType);
    }

    @Override
    public D dimension() {
        return this.binding.dimension();
    }

    @Override
    public String columnName() {
        return this.binding.columnName();
    }

    @Override
    public Scaling scaling() {
        return this.binding.scaling();
    }
}

