/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.coding;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import edu.iu.sci2.visualization.geomaps.data.interpolation.Interpolator;
import edu.iu.sci2.visualization.geomaps.data.scaling.ScalingException;
import edu.iu.sci2.visualization.geomaps.utility.Averages;
import edu.iu.sci2.visualization.geomaps.utility.Continuum;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.NumberFormatFactory;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import edu.iu.sci2.visualization.geomaps.viz.coding.AbstractCoding;
import edu.iu.sci2.visualization.geomaps.viz.legend.ColorLegend;
import edu.iu.sci2.visualization.geomaps.viz.legend.LabeledReference;
import edu.iu.sci2.visualization.geomaps.viz.legend.LegendCreationException;
import edu.iu.sci2.visualization.geomaps.viz.ps.LabeledReferenceGradient;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.cishell.utilities.mutateParameter.dropdown.DropdownMutator;

public abstract class AbstractColorCoding<D extends Enum<D>>
extends AbstractCoding<D, Color> {
    public static final ImmutableMap<String, Continuum<Color>> COLOR_CONTINUUMS = ImmutableMap.builder().put((Object)"White to Green", Continuum.between(new Color(237, 248, 251), new Color(1, 109, 44))).put((Object)"White to Purple", Continuum.between(new Color(237, 248, 251), new Color(129, 14, 124))).put((Object)"Yellow to Orange", Continuum.between(new Color(255, 255, 212), new Color(153, 52, 4))).put((Object)"Yellow to Red", Continuum.between(new Color(255, 255, 178), new Color(189, 0, 38))).put((Object)"Yellow to Blue", Continuum.between(new Color(255, 255, 204), new Color(38, 52, 148))).put((Object)"White to Black", Continuum.between(new Color(247, 247, 247), new Color(37, 37, 37))).build();
    private final Interpolator<Color> interpolator;

    protected AbstractColorCoding(VizDimension.Binding<D> binding, Range<Double> usableRange, Interpolator<Color> interpolator) {
        super(binding, usableRange, interpolator.getOutContinuum());
        this.interpolator = interpolator;
    }

    public abstract Point2D.Double lowerLeft(PageLayout var1);

    @Override
    public LabeledReference makeLabeledReference(PageLayout pageLayout, NumberFormatFactory.NumericFormatType numericFormatType) throws LegendCreationException {
        LabeledReferenceGradient labeledReferenceGradient = new LabeledReferenceGradient(this.createColorLegend(numericFormatType), this.lowerLeft(pageLayout), pageLayout, pageLayout.colorGradientDimensions());
        return labeledReferenceGradient;
    }

    private ColorLegend createColorLegend(NumberFormatFactory.NumericFormatType numericFormatType) throws LegendCreationException {
        try {
            double midpointOfScaledData = Averages.meanOfDoubles((Double)this.interpolator.getInRange().lowerEndpoint(), (Double)this.interpolator.getInRange().upperEndpoint());
            double unscaledValueForMidrangeColor = this.scaling().invert(midpointOfScaledData);
            ColorLegend colorLegend = new ColorLegend(this.makeVizLegend(numericFormatType), unscaledValueForMidrangeColor);
            return colorLegend;
        }
        catch (ScalingException e) {
            throw new LegendCreationException("Problem formatting numbers for legend.", e);
        }
    }

    public static void addColorRangeParameter(DropdownMutator mutator, String rangeParameterId) {
        mutator.add(rangeParameterId, new ArrayList(COLOR_CONTINUUMS.keySet()));
    }
}

