/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.model;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.vividsolutions.jts.geom.Coordinate;
import edu.iu.sci2.visualization.geomaps.data.GeoDataset;
import edu.iu.sci2.visualization.geomaps.data.GeoDatum;
import edu.iu.sci2.visualization.geomaps.viz.AnnotationMode;
import edu.iu.sci2.visualization.geomaps.viz.Circle;
import edu.iu.sci2.visualization.geomaps.viz.CircleDimension;
import edu.iu.sci2.visualization.geomaps.viz.FeatureView;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import edu.iu.sci2.visualization.geomaps.viz.coding.Coding;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import org.cishell.utilities.NumberUtilities;
import prefuse.data.Table;
import prefuse.data.Tuple;

public class CircleAnnotationMode
extends AnnotationMode<Coordinate, CircleDimension> {
    public static final Ordering<GeoDatum<Coordinate, CircleDimension>> AREA_ORDERING = Ordering.natural().nullsFirst().onResultOf((Function)new Function<GeoDatum<Coordinate, CircleDimension>, Double>(){

        public Double apply(GeoDatum<Coordinate, CircleDimension> input) {
            return input.valueInDimension(CircleDimension.AREA);
        }
    });
    private final String longitudeColumnName;
    private final String latitudeColumnName;

    public CircleAnnotationMode(String longitudeColumnName, String latitudeColumnName) {
        this.longitudeColumnName = longitudeColumnName;
        this.latitudeColumnName = latitudeColumnName;
    }

    @Override
    protected EnumSet<CircleDimension> dimensions() {
        return EnumSet.allOf(CircleDimension.class);
    }

    @Override
    protected GeoDataset<Coordinate, CircleDimension> readTable(Table table, Collection<VizDimension.Binding<CircleDimension>> bindings) {
        return GeoDataset.fromTable(table, bindings, CircleDimension.class, new CoordinateReader(this.longitudeColumnName, this.latitudeColumnName));
    }

    public static Collection<Circle> asCirclesInDrawingOrder(Collection<? extends GeoDatum<Coordinate, CircleDimension>> geoData, final Collection<? extends Coding<CircleDimension>> codings) {
        return Collections2.transform((Collection)AREA_ORDERING.reverse().sortedCopy(geoData), (Function)new Function<GeoDatum<Coordinate, CircleDimension>, Circle>(){

            public Circle apply(GeoDatum<Coordinate, CircleDimension> geoDatum) {
                Coordinate coordinate = geoDatum.getGeo();
                EnumMap strategies = Maps.newEnumMap(CircleDimension.class);
                for (Coding coding : codings) {
                    strategies.put((CircleDimension)coding.dimension(), coding.strategyForValue(geoDatum.valueInDimension((CircleDimension)coding.dimension())));
                }
                return new Circle(coordinate, strategies);
            }
        });
    }

    @Override
    protected Collection<Circle> makeCircles(GeoDataset<Coordinate, CircleDimension> scaledData, Collection<? extends Coding<CircleDimension>> codings) {
        return CircleAnnotationMode.asCirclesInDrawingOrder(scaledData.geoData(GeoDataset.Stage.SCALED), codings);
    }

    @Override
    protected Collection<FeatureView> makeFeatureViews(GeoDataset<Coordinate, CircleDimension> scaledData, Collection<? extends Coding<CircleDimension>> codings) {
        return ImmutableSet.of();
    }

    private static class CoordinateReader
    implements AnnotationMode.GeoIdentifierReader<Coordinate> {
        private final String longitudeColumnName;
        private final String latitudeColumnName;

        CoordinateReader(String longitudeColumnName, String latitudeColumnName) {
            this.longitudeColumnName = longitudeColumnName;
            this.latitudeColumnName = latitudeColumnName;
        }

        @Override
        public Coordinate readFrom(Tuple tuple) throws AnnotationMode.GeoIdentifierException {
            Object xObject = tuple.get(this.longitudeColumnName);
            Object yObject = tuple.get(this.latitudeColumnName);
            if (xObject == null || yObject == null) {
                throw new AnnotationMode.GeoIdentifierException(String.format("Missing coordinate info in tuple %s.", tuple));
            }
            Double x = NumberUtilities.interpretObjectAsDouble((Object)xObject);
            Double y = NumberUtilities.interpretObjectAsDouble((Object)yObject);
            if (x == null || y == null) {
                throw new AnnotationMode.GeoIdentifierException(String.format("Uninterpretable coordinate info in tuple %s.", tuple));
            }
            return new Coordinate(x.doubleValue(), y.doubleValue());
        }
    }
}

