/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import edu.iu.sci2.visualization.geomaps.LogStream;
import edu.iu.sci2.visualization.geomaps.geo.projection.GeometryProjector;
import edu.iu.sci2.visualization.geomaps.geo.projection.KnownProjectedCRSDescriptor;
import edu.iu.sci2.visualization.geomaps.geo.shapefiles.Shapefile;
import edu.iu.sci2.visualization.geomaps.viz.Circle;
import edu.iu.sci2.visualization.geomaps.viz.FeatureView;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.legend.LabeledReference;
import edu.iu.sci2.visualization.geomaps.viz.model.GeoMapException;
import edu.iu.sci2.visualization.geomaps.viz.ps.HowToRead;
import edu.iu.sci2.visualization.geomaps.viz.ps.Legendarium;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import org.opengis.referencing.operation.TransformException;

public class GeoMap {
    private final String title;
    private final Shapefile shapefile;
    private final KnownProjectedCRSDescriptor knownProjectedCRSDescriptor;
    private final Collection<FeatureView> featureViews;
    private final Collection<Circle> circles;
    private final Legendarium legendarium;
    private final GeometryProjector geometryProjector;
    private final Collection<Shapefile.Inset> insets;
    private final Optional<HowToRead> howToRead;

    public GeoMap(String title, Shapefile shapefile, KnownProjectedCRSDescriptor knownProjectedCRSDescriptor, Collection<FeatureView> featureViews, Collection<Circle> circles, Collection<LabeledReference> legends, PageLayout pageLayout, Optional<HowToRead> howToRead) throws GeoMapException {
        this.title = title;
        this.shapefile = shapefile;
        this.knownProjectedCRSDescriptor = knownProjectedCRSDescriptor;
        this.featureViews = featureViews;
        this.circles = circles;
        this.howToRead = howToRead;
        this.legendarium = Legendarium.containing(pageLayout.legendariumLowerLeft(), pageLayout, legends);
        try {
            this.geometryProjector = new GeometryProjector(shapefile.detectNativeCRS(), knownProjectedCRSDescriptor);
        }
        catch (GeometryProjector.GeometryProjectorException e) {
            throw new GeoMapException("Failed to create map projection.", e);
        }
        HashSet insets = Sets.newHashSet();
        for (Shapefile.Inset.Request request : shapefile.getInsetRequests()) {
            try {
                insets.add(Shapefile.Inset.forRequest(request, shapefile, this.geometryProjector));
            }
            catch (Shapefile.Inset.InsetCreationException e) {
                LogStream.WARNING.send(e, "Failed to create map inset for feature named \"%s\".", request.getFeatureName());
            }
        }
        this.insets = insets;
    }

    public GeometryProjector getGeometryProjector() {
        return this.geometryProjector;
    }

    public Legendarium getLegendarium() {
        return this.legendarium;
    }

    public Shapefile getShapefile() {
        return this.shapefile;
    }

    public KnownProjectedCRSDescriptor getKnownProjectedCRSDescriptor() {
        return this.knownProjectedCRSDescriptor;
    }

    public Collection<FeatureView> getFeatureViews() {
        return this.featureViews;
    }

    public Collection<Circle> getCircles() {
        return this.circles;
    }

    public Optional<HowToRead> getHowToRead() {
        return this.howToRead;
    }

    public String getTitle() {
        return this.title;
    }

    public Collection<Shapefile.Inset> getInsets() {
        return this.insets;
    }

    public Collection<Geometry> cropTransformAndInset(Geometry naturalGeometry) throws TransformException {
        return this.inset(naturalGeometry, this.geometryProjector.cropAndTransformGeometry(naturalGeometry));
    }

    public Collection<Point> transformAndInset(Coordinate naturalCoordinate) throws TransformException {
        HashSet projectedPoints = Sets.newHashSet();
        for (Point point : this.insetCoordinate(naturalCoordinate, this.geometryProjector.transformCoordinate(naturalCoordinate))) {
            projectedPoints.add(point);
        }
        if (projectedPoints.isEmpty()) {
            throw new AssertionError((Object)String.format("Coordinate %s not present in projection.", naturalCoordinate));
        }
        return projectedPoints;
    }

    public Point transformAndInset(Coordinate naturalCoordinate, Shapefile.Inset inset) throws TransformException {
        return inset.insetPoint(this.geometryProjector.transformCoordinate(naturalCoordinate));
    }

    private Collection<Point> insetCoordinate(Coordinate naturalCoordinate, Point projectedPoint) {
        HashSet points = Sets.newHashSet();
        for (Shapefile.Inset inset : this.insets) {
            if (!inset.shouldInsetCoordinate(naturalCoordinate)) continue;
            points.add(inset.insetPoint(projectedPoint));
        }
        if (points.isEmpty()) {
            points.add(projectedPoint);
        }
        if (points.isEmpty()) {
            throw new AssertionError((Object)String.format("Coordinate %s not present in projection.", naturalCoordinate));
        }
        return points;
    }

    private Collection<Geometry> inset(Geometry naturalGeometry, Geometry projectedGeometry) {
        HashSet geometries = Sets.newHashSet();
        for (Shapefile.Inset inset : this.insets) {
            if (!inset.shouldInset(naturalGeometry)) continue;
            geometries.add(inset.inset(projectedGeometry));
        }
        if (geometries.isEmpty()) {
            return ImmutableSet.of((Object)projectedGeometry);
        }
        return geometries;
    }

    /*
     * Exception decompiling
     */
    public Rectangle2D.Double calculateMapBoundingRectangle() throws TransformException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

