/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.model;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import edu.iu.sci2.visualization.geomaps.data.GeoDataset;
import edu.iu.sci2.visualization.geomaps.data.GeoDatum;
import edu.iu.sci2.visualization.geomaps.viz.AnnotationMode;
import edu.iu.sci2.visualization.geomaps.viz.Circle;
import edu.iu.sci2.visualization.geomaps.viz.FeatureDimension;
import edu.iu.sci2.visualization.geomaps.viz.FeatureView;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import edu.iu.sci2.visualization.geomaps.viz.coding.Coding;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import org.cishell.utilities.StringUtilities;
import prefuse.data.Table;
import prefuse.data.Tuple;

public class RegionAnnotationMode
extends AnnotationMode<String, FeatureDimension> {
    public static final String FEATURE_NAME_ID = "featureName";
    private final String featureNameColumnName;

    public RegionAnnotationMode(String featureNameColumnName) {
        this.featureNameColumnName = featureNameColumnName;
    }

    @Override
    protected EnumSet<FeatureDimension> dimensions() {
        return EnumSet.allOf(FeatureDimension.class);
    }

    @Override
    protected GeoDataset<String, FeatureDimension> readTable(Table table, Collection<VizDimension.Binding<FeatureDimension>> bindings) {
        return GeoDataset.fromTable(table, bindings, FeatureDimension.class, new FeatureNameReader(this.featureNameColumnName));
    }

    public static Collection<FeatureView> asFeatureViews(Collection<? extends GeoDatum<String, FeatureDimension>> valuedFeatures, final Collection<? extends Coding<FeatureDimension>> codings) {
        return Collections2.transform(valuedFeatures, (Function)new Function<GeoDatum<String, FeatureDimension>, FeatureView>(){

            public FeatureView apply(GeoDatum<String, FeatureDimension> valuedFeature) {
                String featureName = valuedFeature.getGeo();
                EnumMap strategies = Maps.newEnumMap(FeatureDimension.class);
                for (Coding coding : codings) {
                    strategies.put((FeatureDimension)coding.dimension(), coding.strategyForValue(valuedFeature.valueInDimension((FeatureDimension)coding.dimension())));
                }
                return new FeatureView(featureName, strategies);
            }
        });
    }

    @Override
    protected Collection<Circle> makeCircles(GeoDataset<String, FeatureDimension> scaledData, Collection<? extends Coding<FeatureDimension>> codings) {
        return ImmutableSet.of();
    }

    @Override
    protected Collection<FeatureView> makeFeatureViews(GeoDataset<String, FeatureDimension> scaledData, Collection<? extends Coding<FeatureDimension>> codings) {
        return RegionAnnotationMode.asFeatureViews(scaledData.geoData(GeoDataset.Stage.SCALED), codings);
    }

    public static String normalizeFeatureName(String featureName) {
        return featureName.toLowerCase();
    }

    private static class FeatureNameReader
    implements AnnotationMode.GeoIdentifierReader<String> {
        private final String featureNameColumnName;

        FeatureNameReader(String featureNameColumnName) {
            this.featureNameColumnName = featureNameColumnName;
        }

        @Override
        public String readFrom(Tuple tuple) throws AnnotationMode.GeoIdentifierException {
            Object featureNameObject = tuple.get(this.featureNameColumnName);
            String featureName = StringUtilities.interpretObjectAsString((Object)featureNameObject);
            if (featureName == null) {
                throw new AnnotationMode.GeoIdentifierException(String.format("Missing feature name info in tuple %s.", tuple));
            }
            return RegionAnnotationMode.normalizeFeatureName(featureName);
        }
    }
}

