/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.ps;

import com.google.common.base.Equivalences;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import edu.iu.sci2.visualization.geomaps.LogStream;
import edu.iu.sci2.visualization.geomaps.utility.Iterables2;
import edu.iu.sci2.visualization.geomaps.utility.Lists2;
import edu.iu.sci2.visualization.geomaps.utility.Points;
import edu.iu.sci2.visualization.geomaps.viz.FeatureDimension;
import edu.iu.sci2.visualization.geomaps.viz.FeatureView;
import edu.iu.sci2.visualization.geomaps.viz.model.GeoMap;
import edu.iu.sci2.visualization.geomaps.viz.ps.GeoMapViewPageArea;
import edu.iu.sci2.visualization.geomaps.viz.ps.PSUtility;
import edu.iu.sci2.visualization.geomaps.viz.strategy.NullColorStrategy;
import edu.iu.sci2.visualization.geomaps.viz.strategy.Strategy;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cishell.utilities.ArrayListUtilities;
import org.cishell.utilities.StringUtilities;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.operation.TransformException;

public class FeaturePrinter {
    private static final double GLITCH_DETECTION_THRESHOLD = 150.0;
    private static final double BORDER_BRIGHTNESS = 0.7;
    private static final double BORDER_LINE_WIDTH = 0.4;
    private final GeoMap geoMap;
    private final GeoMapViewPageArea geoMapViewPageArea;
    private Map<String, Boolean> featureWasColoredMap;

    public FeaturePrinter(GeoMap geoMap, GeoMapViewPageArea geoMapViewPageArea) {
        this.geoMap = geoMap;
        this.geoMapViewPageArea = geoMapViewPageArea;
    }

    public void printFeatures(BufferedWriter out, Collection<FeatureView> featureViews) throws IOException, TransformException {
        this.featureWasColoredMap = new HashMap<String, Boolean>();
        for (FeatureView featureView : featureViews) {
            String featureName = featureView.getFeatureName();
            this.featureWasColoredMap.put(featureName, false);
        }
        ImmutableMap featureColorMap = Maps.uniqueIndex(featureViews, (Function)new Function<FeatureView, String>(){

            public String apply(FeatureView featureView) {
                return featureView.getFeatureName();
            }
        });
        out.write("% Features\n");
        out.write("gsave\n");
        out.write("    0.4 setlinewidth\n");
        out.write(String.valueOf(PSUtility.setgray(0.7)) + "\n");
        out.write("\n");
        FeatureIterator featuresIt = this.geoMap.getShapefile().viewOfFeatureCollection().features();
        try {
            while (featuresIt.hasNext()) {
                this.printFeature(out, (SimpleFeature)featuresIt.next(), (ImmutableMap<String, FeatureView>)featureColorMap);
            }
        }
        finally {
            featuresIt.close();
        }
        out.write("grestore\n");
        out.write("\n");
        this.reportUnfoundFeatures();
    }

    private void reportUnfoundFeatures() {
        ArrayList<String> unfoundFeatureNames = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : this.featureWasColoredMap.entrySet()) {
            String featureName = entry.getKey();
            boolean featureWasColored = entry.getValue();
            if (featureWasColored) continue;
            unfoundFeatureNames.add(featureName);
        }
        if (unfoundFeatureNames.size() > 0) {
            String unfoundFeatureNamesPreview = ArrayListUtilities.makePreview(unfoundFeatureNames, (int)6, (int)3, (String)", ", (String)"...");
            String shortMessage = String.format("%d regions had data associated in the table but could not be found in the shapefile (using region name key \"%s\") and so could not be colored: %s.", unfoundFeatureNames.size(), this.geoMap.getShapefile().getFeatureAttributeName(), unfoundFeatureNamesPreview);
            if (unfoundFeatureNames.size() > 9) {
                shortMessage = String.valueOf(shortMessage) + " The full list is in the log file.";
            }
            LogStream.WARNING.send(shortMessage, new Object[0]);
            String fullMessage = String.format("These regions could not be found in the shapefile (using region name key \"%s\"): %s.", this.geoMap.getShapefile().getFeatureAttributeName(), StringUtilities.implodeItems(unfoundFeatureNames, (String)", "));
            LogStream.DEBUG.send(fullMessage, new Object[0]);
        }
    }

    private void printFeature(BufferedWriter out, SimpleFeature feature, ImmutableMap<String, FeatureView> featureColorMap) throws IOException, TransformException {
        String featureName = this.geoMap.getShapefile().extractFeatureName(feature);
        for (Geometry geometry : this.geoMap.cropTransformAndInset((Geometry)feature.getDefaultGeometry())) {
            int numberOfSubgeometries = geometry.getNumGeometries();
            int gg = 0;
            while (gg < numberOfSubgeometries) {
                out.write("    % Feature, " + this.geoMap.getShapefile().getFeatureAttributeName() + " = " + featureName + ", subgeometry " + gg + "\n");
                this.printGeometry(geometry.getGeometryN(gg), out, (Map<String, FeatureView>)featureColorMap, featureName);
                ++gg;
            }
        }
        out.write("\n");
    }

    private void printGeometry(Geometry subgeometry, BufferedWriter out, Map<String, FeatureView> featureColorMap, String name) throws IOException {
        ImmutableList coordinates = ImmutableList.copyOf((Object[])subgeometry.getCoordinates());
        if (coordinates.isEmpty()) {
            return;
        }
        List displayPoints = Lists.transform((List)coordinates, (Function)new Function<Coordinate, Point2D.Double>(){

            public Point2D.Double apply(Coordinate projectedCoordinate) {
                return FeaturePrinter.this.geoMapViewPageArea.displayPointFor(projectedCoordinate);
            }
        });
        List distinctDisplayPoints = Lists2.omitConsecutiveDuplicates(displayPoints, Equivalences.equals());
        List<List<Point2D.Double>> paths = Iterables2.split(distinctDisplayPoints, Points.distanceEquivalenceWithTolerance(150.0));
        List<List<Point2D.Double>> pathsExceptLast = paths.subList(0, paths.size() - 1);
        List<Point2D.Double> lastPath = paths.get(paths.size() - 1);
        for (List<Point2D.Double> path : pathsExceptLast) {
            out.write(String.valueOf(PSUtility.path(path)) + " stroke ");
        }
        out.write(PSUtility.path(lastPath));
        out.write("\n closepath \n");
        this.writeInkingCommands(out, featureColorMap, name);
    }

    private void writeInkingCommands(BufferedWriter out, Map<String, FeatureView> featureColorMap, String featureName) throws IOException {
        Strategy colorStrategy = new NullColorStrategy();
        if (featureColorMap.containsKey(featureName)) {
            this.featureWasColoredMap.put(featureName, true);
            colorStrategy = featureColorMap.get(featureName).strategyFor(FeatureDimension.REGION_COLOR);
        }
        out.write(colorStrategy.toPostScript());
        out.write("stroke\n");
    }
}

