/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.ps;

import com.google.common.collect.Iterables;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import edu.iu.sci2.visualization.geomaps.GeoMapsAlgorithm;
import edu.iu.sci2.visualization.geomaps.LogStream;
import edu.iu.sci2.visualization.geomaps.geo.shapefiles.Shapefile;
import edu.iu.sci2.visualization.geomaps.viz.Circle;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.model.GeoMap;
import edu.iu.sci2.visualization.geomaps.viz.ps.DSCProlog;
import edu.iu.sci2.visualization.geomaps.viz.ps.FeaturePrinter;
import edu.iu.sci2.visualization.geomaps.viz.ps.GeoMapViewPageArea;
import edu.iu.sci2.visualization.geomaps.viz.ps.HowToRead;
import edu.iu.sci2.visualization.geomaps.viz.ps.PSUtility;
import edu.iu.sci2.visualization.geomaps.viz.ps.PageFooter;
import edu.iu.sci2.visualization.geomaps.viz.ps.PageHeader;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.cishell.utilities.FileUtilities;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.opengis.referencing.operation.TransformException;

public class GeoMapViewPS {
    static final StringTemplateGroup TEMPLATE_GROUP = GeoMapViewPS.loadTemplates();
    private static final String STRING_TEMPLATE_RESOURCE_PATH = "/edu/iu/sci2/visualization/geomaps/viz/stringtemplates/geomap.stg";
    private final GeoMap geoMap;
    private final PageLayout pageLayout;
    private final GeoMapViewPageArea geoMapViewPageArea;

    public GeoMapViewPS(GeoMap geoMap, PageLayout pageLayout) throws ShapefilePostScriptWriterException {
        try {
            this.geoMap = geoMap;
            this.pageLayout = pageLayout;
            Rectangle2D.Double dataRectangle = geoMap.calculateMapBoundingRectangle();
            Rectangle2D.Double displayRectangle = pageLayout.calculateMapRectangle(dataRectangle);
            this.geoMapViewPageArea = new GeoMapViewPageArea(dataRectangle, displayRectangle);
        }
        catch (TransformException e) {
            throw new ShapefilePostScriptWriterException(e);
        }
    }

    public File writeToPSFile(String dataLabel, String fileExtension) throws IOException, TransformException {
        File psFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"geoMaps", (String)fileExtension);
        BufferedWriter out = new BufferedWriter(new FileWriter(psFile));
        try {
            LogStream.INFO.send("Printing PostScript..\n", new Object[0]);
            out.write(new DSCProlog(this.geoMap.getTitle(), this.pageLayout.pageDimensions()).toPostScript());
            out.write(TEMPLATE_GROUP.getInstanceOf("utilityDefinitions").toString());
            out.write("\n");
            out.write(String.valueOf(new PageFooter(new Point2D.Double(this.pageLayout.pageDimensions().getWidth() / 2.0, 0.75 * this.pageLayout.pageMargin()), this.pageLayout).toPostScript()) + "\n");
            out.write("% Save the default clipping path so we can clip the map safely\n");
            out.write("gsave\n");
            out.write("\n");
            out.write(this.geoMapViewPageArea.toPostScript());
            out.write("\n");
            FeaturePrinter featurePrinter = new FeaturePrinter(this.geoMap, this.geoMapViewPageArea);
            featurePrinter.printFeatures(out, this.geoMap.getFeatureViews());
            for (Shapefile.Inset inset : this.geoMap.getInsets()) {
                Coordinate labelLowerLeftCoordinate = inset.getLabelLowerLeft();
                Point projectedAndInset = this.geoMap.transformAndInset(labelLowerLeftCoordinate, inset);
                Point2D.Double labelLowerLeftPoint = this.geoMapViewPageArea.displayPointFor(projectedAndInset.getCoordinate());
                out.write(" gsave ");
                out.write(PSUtility.findscalesetfont(this.pageLayout.contentFont()));
                out.write(String.valueOf(PSUtility.xy(labelLowerLeftPoint)) + " moveto ");
                out.write(String.format(" (%s) show ", inset.makeLabel()));
                out.write(" grestore ");
            }
            out.write(TEMPLATE_GROUP.getInstanceOf("circlePrinterDefinitions").toString());
            out.write("% Circle annotations\n");
            out.write("gsave\n");
            out.write("\n");
            double circleLineWidth = 1.5;
            out.write("    " + circleLineWidth + " setlinewidth" + "\n");
            out.write("\n");
            for (Circle circle : this.geoMap.getCircles()) {
                out.write(circle.toPostScript(this.geoMap, this.geoMapViewPageArea));
            }
            out.write("grestore\n");
            out.write("\n");
            out.write("% Restore the default clipping path\n");
            out.write("grestore\n");
            out.write("\n");
            if (this.pageLayout.headerLowerLeft().isPresent()) {
                String escapedLabel = PSUtility.escapeForPostScript(dataLabel).trim();
                PageHeader pageHeader = new PageHeader(this.geoMap.getTitle(), (Point2D.Double)this.pageLayout.headerLowerLeft().get(), this.pageLayout, escapedLabel.isEmpty() ? "" : String.format(escapedLabel, new Object[0]), GeoMapViewPS.timestamp());
                out.write(pageHeader.toPostScript());
                out.write("\n");
            }
            out.write(this.geoMap.getLegendarium().toPostScript());
            out.write("\n");
            if (this.geoMap.getHowToRead().isPresent()) {
                out.write(((HowToRead)this.geoMap.getHowToRead().get()).toPostScript());
            }
            out.write("showpage\n");
        }
        finally {
            out.close();
        }
        LogStream.INFO.send("Done.", new Object[0]);
        return psFile;
    }

    private static String timestamp() {
        return DateTimeFormat.forPattern((String)"MMM dd, yyyy | hh:mm:ss aa z").print((ReadableInstant)new DateTime());
    }

    public Point2D.Double transformAndInsetToPagePoint(Coordinate coordinate) throws TransformException {
        Collection<Point> projectedPoints = this.geoMap.transformAndInset(coordinate);
        if (projectedPoints.isEmpty()) {
            throw new AssertionError((Object)String.format("Coordinate %s not present in projection.", coordinate));
        }
        Point someProjectedPoint = (Point)Iterables.getFirst(projectedPoints, null);
        if (projectedPoints.size() > 1) {
            LogStream.WARNING.send("The coordinate \"%s\" projected to multiple display points.  This can happen if the insets defined for this base map have overlapping bounding boxes.  A point has been chosen arbitrarily from the possibilities.", coordinate);
        }
        return this.geoMapViewPageArea.displayPointFor(someProjectedPoint.getCoordinate());
    }

    public static StringTemplateGroup loadTemplates() {
        return new StringTemplateGroup((Reader)new InputStreamReader(GeoMapsAlgorithm.class.getResourceAsStream(STRING_TEMPLATE_RESOURCE_PATH)));
    }

    public static class ShapefilePostScriptWriterException
    extends Exception {
        private static final long serialVersionUID = -4207770884445237065L;

        public ShapefilePostScriptWriterException(String message, Throwable cause) {
            super(message, cause);
        }

        public ShapefilePostScriptWriterException(Throwable cause) {
            super(cause);
        }
    }
}

