/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.ps;

import com.vividsolutions.jts.geom.Coordinate;
import edu.iu.sci2.visualization.geomaps.data.interpolation.Interpolator1D;
import edu.iu.sci2.visualization.geomaps.utility.Continuum;
import edu.iu.sci2.visualization.geomaps.utility.Rectangles;
import edu.iu.sci2.visualization.geomaps.viz.ps.PSUtility;
import edu.iu.sci2.visualization.geomaps.viz.ps.PostScriptable;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GeoMapViewPageArea
implements PostScriptable {
    private static final boolean CLIP_TO_BOUNDING_BOX = false;
    private static final boolean BACKGROUND_TRANSPARENT = true;
    private static final Color BACKGROUND_COLOR = Color.CYAN;
    private static final boolean DRAW_BOUNDING_BOX = false;
    private static final double BOUNDING_BOX_LINE_WIDTH = 0.2;
    private final Rectangle2D.Double displayRectangle;
    private final Interpolator1D xInterpolator;
    private final Interpolator1D yInterpolator;

    public GeoMapViewPageArea(Rectangle2D.Double dataRectangle, Rectangle2D.Double displayRectangle) {
        this.displayRectangle = displayRectangle;
        this.xInterpolator = Interpolator1D.between(Rectangles.xRange(dataRectangle), Continuum.fromRange(Rectangles.xRange(displayRectangle)));
        this.yInterpolator = Interpolator1D.between(Rectangles.yRange(dataRectangle), Continuum.fromRange(Rectangles.yRange(displayRectangle)));
    }

    public Point2D.Double displayPointFor(Coordinate projectedCoordinate) {
        return new Point2D.Double(this.xInterpolator.apply(projectedCoordinate.x), this.yInterpolator.apply(projectedCoordinate.y));
    }

    @Override
    public String toPostScript() {
        String s = "";
        s = String.valueOf(s) + PSUtility.closedPath(new Point2D.Double(this.displayRectangle.getMinX(), this.displayRectangle.getMinY()), new Point2D.Double(this.displayRectangle.getMinX(), this.displayRectangle.getMaxY()), new Point2D.Double(this.displayRectangle.getMaxX(), this.displayRectangle.getMaxY()), new Point2D.Double(this.displayRectangle.getMaxX(), this.displayRectangle.getMinY()));
        return s;
    }
}

