/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.ps;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.iu.cns.visualization.utility.wordwrap.LineMetric;
import edu.iu.cns.visualization.utility.wordwrap.LineMetrics;
import edu.iu.cns.visualization.utility.wordwrap.WordWrapper;
import edu.iu.sci2.visualization.geomaps.GeoMapsAlgorithm;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.ps.PSUtility;
import edu.iu.sci2.visualization.geomaps.viz.ps.PostScriptable;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplateGroup;

public class HowToRead
implements PostScriptable {
    public static final String STRING_TEMPLATE_FILE_PATH = "/edu/iu/sci2/visualization/geomaps/viz/stringtemplates/howToRead.stg";
    public static StringTemplateGroup TEMPLATE_GROUP = HowToRead.loadTemplateGroup();
    public static final double TITLE_FONT_GRAY = 0.0;
    public static final double TEXT_FONT_GRAY = 0.15;
    private final Point2D.Double lowerLeft;
    private final PageLayout pageLayout;
    private final String text;
    private final String mapKind;

    public HowToRead(Point2D.Double lowerLeft, PageLayout pageLayout, String text, String mapKind) {
        this.lowerLeft = lowerLeft;
        this.pageLayout = pageLayout;
        this.text = text;
        this.mapKind = mapKind;
    }

    @Override
    public String toPostScript() {
        String howToRead = "";
        howToRead = String.valueOf(howToRead) + "% How to Read\n";
        howToRead = String.valueOf(howToRead) + "gsave\n";
        howToRead = String.valueOf(howToRead) + HowToRead.showTitle(this.lowerLeft, this.pageLayout.titleFont());
        howToRead = String.valueOf(howToRead) + HowToRead.showContent(this.lowerLeft, this.pageLayout, this.text, this.mapKind);
        howToRead = String.valueOf(howToRead) + "grestore\n";
        return howToRead;
    }

    private static String showTitle(Point2D.Double point, Font font) {
        String title = "";
        title = String.valueOf(title) + String.format("%f %f moveto\n", point.x, point.y);
        title = String.valueOf(title) + PSUtility.findscalesetfont(font) + "\n";
        title = String.valueOf(title) + PSUtility.setgray(0.0) + "\n";
        title = String.valueOf(title) + "(How to Read this Map) show\n";
        return title;
    }

    private static String showContent(Point2D.Double lowerLeft, PageLayout pageLayout, String text, String mapKind) {
        String content = "";
        ArrayList lines = Lists.newArrayList((Iterable)WordWrapper.fewestLines((LineMetric)LineMetrics.widthInFont((Font)pageLayout.contentFont()), (int)((Double)pageLayout.howToReadWidth().get()).intValue()).wrap(text));
        List<String> restOfLines = lines.subList(1, lines.size());
        Point2D.Double firstLineStartPoint = new Point2D.Double(lowerLeft.x, lowerLeft.y - (double)pageLayout.titleFont().getSize());
        Point2D.Double secondLineStartPoint = new Point2D.Double(firstLineStartPoint.x, firstLineStartPoint.y - (double)pageLayout.contentFont().getSize());
        content = String.valueOf(content) + String.format("%f %f moveto", firstLineStartPoint.x, firstLineStartPoint.y) + "\n";
        content = String.valueOf(content) + PSUtility.findscalesetfont(pageLayout.contentFont()) + "\n";
        content = String.valueOf(content) + PSUtility.setgray(0.15) + "\n";
        String firstLine = (String)lines.get(0);
        Iterable firstLineParts = Splitter.on((String)mapKind).split((CharSequence)firstLine);
        String beforeMapKind = (String)Iterables.get((Iterable)firstLineParts, (int)0);
        String afterMapKind = (String)Iterables.get((Iterable)firstLineParts, (int)1);
        content = String.valueOf(content) + String.format("(%s) show ", beforeMapKind);
        content = String.valueOf(content) + PSUtility.findscalesetfont(pageLayout.contentFont().deriveFont(2)) + " " + String.format("(%s) show", mapKind) + " " + PSUtility.findscalesetfont(pageLayout.contentFont());
        content = String.valueOf(content) + String.format("(%s) show ", afterMapKind);
        content = String.valueOf(content) + PSUtility.showLines(restOfLines, secondLineStartPoint, pageLayout.contentFont().getSize());
        return content;
    }

    private static StringTemplateGroup loadTemplateGroup() {
        return new StringTemplateGroup((Reader)new InputStreamReader(GeoMapsAlgorithm.class.getResourceAsStream(STRING_TEMPLATE_FILE_PATH)));
    }
}

