/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.ps;

import edu.iu.sci2.visualization.geomaps.utility.numberformat.NumberFormatFactory;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.UnsignedZeroFormat;
import edu.iu.sci2.visualization.geomaps.viz.Circle;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.legend.AreaLegend;
import edu.iu.sci2.visualization.geomaps.viz.legend.LabeledReference;
import edu.iu.sci2.visualization.geomaps.viz.ps.GeoMapViewPS;
import edu.iu.sci2.visualization.geomaps.viz.ps.PSUtility;
import java.awt.geom.Point2D;
import org.antlr.stringtemplate.StringTemplate;

public class LabeledReferenceCircles
implements LabeledReference {
    public static final double CIRCLE_BRIGHTNESS = 0.0;
    public static final double EXTREMA_LABEL_BRIGHTNESS = 0.0;
    public static final double TYPE_LABEL_BRIGHTNESS = 0.0;
    public static final double SCALING_LABEL_BRIGHTNESS = 0.25;
    public static final double KEY_LABEL_BRIGHTNESS = 0.5;
    private final AreaLegend areaLegend;
    private final Point2D.Double keyTextLowerLeft;
    private final PageLayout pageLayout;
    private boolean hasPrintedDefinitions;

    public LabeledReferenceCircles(AreaLegend areaLegend, Point2D.Double keyTextLowerLeft, PageLayout pageLayout) {
        this.areaLegend = areaLegend;
        this.keyTextLowerLeft = keyTextLowerLeft;
        this.pageLayout = pageLayout;
        this.hasPrintedDefinitions = false;
    }

    @Override
    public String toPostScript() {
        double extremaLabelFontSize = 0.8 * (double)this.pageLayout.contentFont().getSize();
        double typeLabelFontSize = this.pageLayout.contentFont().getSize();
        double keyLabelFontSize = 0.8 * (double)this.pageLayout.contentFont().getSize();
        String s = "";
        if (!this.hasPrintedDefinitions) {
            StringTemplate definitionsTemplate = GeoMapViewPS.TEMPLATE_GROUP.getInstanceOf("circleAreaLegendDefinitions");
            s = String.valueOf(s) + definitionsTemplate.toString();
            this.hasPrintedDefinitions = true;
        }
        StringTemplate invocationTemplate = GeoMapViewPS.TEMPLATE_GROUP.getInstanceOf("circleAreaLegend");
        invocationTemplate.setAttribute("x", (Object)this.keyTextLowerLeft.x);
        invocationTemplate.setAttribute("y", (Object)this.keyTextLowerLeft.y);
        invocationTemplate.setAttribute("minRadius", (Object)Circle.calculateRadiusFromArea(this.areaLegend.getVizContinuum().getPointA()));
        invocationTemplate.setAttribute("midRadius", (Object)Circle.calculateRadiusFromArea(this.areaLegend.getMidpointArea()));
        invocationTemplate.setAttribute("maxRadius", (Object)Circle.calculateRadiusFromArea(this.areaLegend.getVizContinuum().getPointB()));
        invocationTemplate.setAttribute("circleBrightness", (Object)0.0);
        UnsignedZeroFormat doubleFormatter = NumberFormatFactory.getNumberFormat(this.areaLegend.numericFormatType(), (Double)this.areaLegend.getDataRange().lowerEndpoint(), this.areaLegend.getDataValueForOutputMidpoint(), (Double)this.areaLegend.getDataRange().upperEndpoint());
        invocationTemplate.setAttribute("minLabel", (Object)doubleFormatter.format((Double)this.areaLegend.getDataRange().lowerEndpoint()));
        invocationTemplate.setAttribute("midLabel", (Object)doubleFormatter.format(this.areaLegend.getDataValueForOutputMidpoint()));
        invocationTemplate.setAttribute("maxLabel", (Object)doubleFormatter.format((Double)this.areaLegend.getDataRange().upperEndpoint()));
        invocationTemplate.setAttribute("extremaLabelBrightness", (Object)0.0);
        invocationTemplate.setAttribute("extremaLabelFontSize", (Object)extremaLabelFontSize);
        invocationTemplate.setAttribute("typeLabel", (Object)this.areaLegend.legendDescription());
        invocationTemplate.setAttribute("typeLabelBrightness", (Object)0.0);
        invocationTemplate.setAttribute("typeLabelFontSize", (Object)typeLabelFontSize);
        invocationTemplate.setAttribute("scalingLabel", (Object)("(" + this.areaLegend.scalingLabel() + ")"));
        invocationTemplate.setAttribute("scalingLabelBrightness", (Object)0.25);
        invocationTemplate.setAttribute("keyLabel", (Object)PSUtility.escapeForPostScript(this.areaLegend.columnName()));
        invocationTemplate.setAttribute("keyLabelBrightness", (Object)0.5);
        invocationTemplate.setAttribute("keyLabelFontSize", (Object)keyLabelFontSize);
        invocationTemplate.setAttribute("fontName", (Object)PSUtility.psFontName(this.pageLayout.contentFont()));
        s = String.valueOf(s) + invocationTemplate.toString();
        return s;
    }
}

