/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.ps;

import edu.iu.sci2.visualization.geomaps.utility.ColorTuples;
import edu.iu.sci2.visualization.geomaps.utility.Dimension;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.NumberFormatFactory;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.UnsignedZeroFormat;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.legend.ColorLegend;
import edu.iu.sci2.visualization.geomaps.viz.legend.LabeledReference;
import edu.iu.sci2.visualization.geomaps.viz.ps.GeoMapViewPS;
import edu.iu.sci2.visualization.geomaps.viz.ps.PSUtility;
import java.awt.Color;
import java.awt.geom.Point2D;
import org.antlr.stringtemplate.StringTemplate;

public class LabeledReferenceGradient
implements LabeledReference {
    public static final int GRADIENT_RESOLUTION = 1;
    public static final double EXTREMA_LABEL_BRIGHTNESS = 0.0;
    public static final double TYPE_LABEL_BRIGHTNESS = 0.0;
    public static final double SCALING_LABEL_BRIGHTNESS = 0.25;
    public static final double KEY_LABEL_BRIGHTNESS = 0.5;
    private final ColorLegend legend;
    private final Point2D.Double lowerLeft;
    private final PageLayout pageLayout;
    private final Dimension<Double> dimension;
    private boolean hasPrintedDefinitions;

    public LabeledReferenceGradient(ColorLegend legend, Point2D.Double lowerLeft, PageLayout pageLayout, Dimension<Double> dimension) {
        this.legend = legend;
        this.lowerLeft = lowerLeft;
        this.pageLayout = pageLayout;
        this.dimension = dimension;
        this.hasPrintedDefinitions = false;
    }

    @Override
    public String toPostScript() {
        double extremaLabelFontSize = 0.8 * (double)this.pageLayout.contentFont().getSize();
        double typeLabelFontSize = this.pageLayout.contentFont().getSize();
        double keyLabelFontSize = 0.8 * (double)this.pageLayout.contentFont().getSize();
        String s = "";
        if (!this.hasPrintedDefinitions) {
            StringTemplate definitionsTemplate = GeoMapViewPS.TEMPLATE_GROUP.getInstanceOf("colorLegendDefinitions");
            s = String.valueOf(s) + definitionsTemplate.toString();
            this.hasPrintedDefinitions = true;
        }
        StringTemplate invocationTemplate = GeoMapViewPS.TEMPLATE_GROUP.getInstanceOf("colorLegend");
        invocationTemplate.setAttribute("x", (Object)this.lowerLeft.x);
        invocationTemplate.setAttribute("y", (Object)this.lowerLeft.y);
        invocationTemplate.setAttribute("gradientWidth", (Object)this.dimension.getWidth());
        invocationTemplate.setAttribute("gradientHeight", (Object)this.dimension.getHeight());
        invocationTemplate.setAttribute("gradientResolution", 1);
        Color minColor = this.legend.getVizContinuum().getPointA();
        double[] minColorTuple = ColorTuples.asTuple(minColor);
        invocationTemplate.setAttribute("minColorRed", (Object)minColorTuple[0]);
        invocationTemplate.setAttribute("minColorGreen", (Object)minColorTuple[1]);
        invocationTemplate.setAttribute("minColorBlue", (Object)minColorTuple[2]);
        Color maxColor = this.legend.getVizContinuum().getPointB();
        double[] maxColorTuple = ColorTuples.asTuple(maxColor);
        invocationTemplate.setAttribute("maxColorRed", (Object)maxColorTuple[0]);
        invocationTemplate.setAttribute("maxColorGreen", (Object)maxColorTuple[1]);
        invocationTemplate.setAttribute("maxColorBlue", (Object)maxColorTuple[2]);
        UnsignedZeroFormat doubleFormatter = NumberFormatFactory.getNumberFormat(this.legend.getNumericFormatType(), (Double)this.legend.getDataRange().lowerEndpoint(), this.legend.getDataValueForOutRangeMidpoint(), (Double)this.legend.getDataRange().upperEndpoint());
        invocationTemplate.setAttribute("minLabel", (Object)doubleFormatter.format((Double)this.legend.getDataRange().lowerEndpoint()));
        invocationTemplate.setAttribute("midLabel", (Object)doubleFormatter.format(this.legend.getDataValueForOutRangeMidpoint()));
        invocationTemplate.setAttribute("maxLabel", (Object)doubleFormatter.format((Double)this.legend.getDataRange().upperEndpoint()));
        invocationTemplate.setAttribute("extremaLabelBrightness", (Object)0.0);
        invocationTemplate.setAttribute("extremaLabelFontSize", (Object)extremaLabelFontSize);
        invocationTemplate.setAttribute("typeLabel", (Object)this.legend.getLegendDescription());
        invocationTemplate.setAttribute("typeLabelBrightness", (Object)0.0);
        invocationTemplate.setAttribute("typeLabelFontSize", (Object)typeLabelFontSize);
        invocationTemplate.setAttribute("scalingLabel", (Object)("(" + this.legend.getScalingLabel() + ")"));
        invocationTemplate.setAttribute("scalingLabelBrightness", (Object)0.25);
        invocationTemplate.setAttribute("keyLabel", (Object)PSUtility.escapeForPostScript(this.legend.getColumnName()));
        invocationTemplate.setAttribute("keyLabelBrightness", (Object)0.5);
        invocationTemplate.setAttribute("keyLabelFontSize", (Object)keyLabelFontSize);
        invocationTemplate.setAttribute("fontName", (Object)PSUtility.psFontName(this.pageLayout.contentFont()));
        s = String.valueOf(s) + invocationTemplate.toString();
        return s;
    }
}

