/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.ps;

import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.legend.LabeledReference;
import edu.iu.sci2.visualization.geomaps.viz.ps.GeoMapViewPS;
import edu.iu.sci2.visualization.geomaps.viz.ps.PSUtility;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.antlr.stringtemplate.StringTemplate;

public class Legendarium {
    private final Point2D.Double lowerLeft;
    private final PageLayout pageLayout;
    private final Collection<LabeledReference> labeledReferences;
    private boolean hasPrintedDefinitions;

    private Legendarium(Point2D.Double lowerLeft, PageLayout pageLayout, Collection<LabeledReference> labeledReferences) {
        this.lowerLeft = lowerLeft;
        this.pageLayout = pageLayout;
        this.labeledReferences = labeledReferences;
        this.hasPrintedDefinitions = false;
    }

    public static Legendarium containing(Point2D.Double lowerLeft, PageLayout pageLayout, Collection<LabeledReference> labeledReferences) {
        return new Legendarium(lowerLeft, pageLayout, labeledReferences);
    }

    public String toPostScript() {
        if (this.labeledReferences.isEmpty()) {
            return " ";
        }
        StringBuilder ps = new StringBuilder();
        if (!this.hasPrintedDefinitions) {
            StringTemplate definitionsTemplate = GeoMapViewPS.TEMPLATE_GROUP.getInstanceOf("legendDefinitions");
            ps.append(definitionsTemplate.toString());
            this.hasPrintedDefinitions = true;
        }
        ps.append("gsave\n");
        ps.append(String.format("%f %f moveto\n", this.lowerLeft.x, this.lowerLeft.y));
        ps.append(String.valueOf(PSUtility.findscalesetfont(this.pageLayout.titleFont())) + "\n");
        ps.append(String.valueOf(PSUtility.setgray(0.0)) + "\n");
        ps.append("(Legend) show\n");
        ps.append("grestore\n");
        for (LabeledReference labeledReference : this.labeledReferences) {
            ps.append(labeledReference.toPostScript());
            ps.append("\n");
        }
        return ps.toString();
    }
}

