/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.ps;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.List;

public class PSUtility {
    public static final ImmutableMap<Integer, String> PS_FONT_NAME_SUFFIX_FOR_FONT_STYLE = ImmutableMap.of((Object)1, (Object)"-Bold", (Object)2, (Object)"-Italic");

    private PSUtility() {
    }

    public static String makeSetRGBColorCommand(Color color) {
        float[] colorComponents = new float[3];
        color.getColorComponents(colorComponents);
        float red = colorComponents[0];
        float green = colorComponents[1];
        float blue = colorComponents[2];
        return String.format("%f %f %f setrgbcolor ", Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue));
    }

    public static String psFontName(Font font) {
        String name = font.getName();
        int style = font.getStyle();
        if (PS_FONT_NAME_SUFFIX_FOR_FONT_STYLE.containsKey((Object)style)) {
            name = String.valueOf(name) + (String)PS_FONT_NAME_SUFFIX_FOR_FONT_STYLE.get((Object)style);
        }
        if (Objects.equal((Object)font.getName(), (Object)"Arial")) {
            name = String.valueOf(name) + "MT";
        }
        return name;
    }

    public static String showAndNewLine(String text, double fontSize) {
        return String.format("(%s) dup show stringwidth pop neg %f rmoveto \n", text, -fontSize);
    }

    public static String showLines(List<String> lines, Point2D.Double point, double fontSize) {
        StringBuilder builder = new StringBuilder();
        int ii = 0;
        while (ii < lines.size()) {
            builder.append(String.format("%f %f moveto ", point.x, point.y - (double)ii * fontSize));
            builder.append(String.format("(%s) show ", lines.get(ii)));
            ++ii;
        }
        return builder.toString();
    }

    public static String escapeForPostScript(String string) {
        return string.replace("\\", "\\\\").replace("(", "\\(").replace(")", "\\)").replace("%", "\\%");
    }

    public static String findscalesetfont(Font font) {
        return String.format("/%s findfont %d scalefont setfont ", PSUtility.psFontName(font), font.getSize());
    }

    public static String setgray(double brightness) {
        return String.format("%f setgray ", brightness);
    }

    public static String path(List<? extends Point2D.Double> points) {
        Preconditions.checkArgument((!points.isEmpty() ? 1 : 0) != 0);
        return PSUtility.path((Point2D.Double)Iterables.getFirst(points, null), (Point2D.Double[])Iterables.toArray((Iterable)Iterables.skip(points, (int)1), Point2D.Double.class));
    }

    public static String closedPath(List<? extends Point2D.Double> points) {
        Preconditions.checkArgument((!points.isEmpty() ? 1 : 0) != 0);
        return String.valueOf(PSUtility.path(points)) + " closepath ";
    }

    public static String path(Point2D.Double first, Point2D.Double ... rest) {
        StringBuilder builder = new StringBuilder();
        builder.append(" newpath ");
        builder.append(String.format("%s moveto ", PSUtility.xy(first)));
        Point2D.Double[] doubleArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Double point = doubleArray[n2];
            builder.append(String.format("%s lineto ", PSUtility.xy(point)));
            ++n2;
        }
        return builder.toString();
    }

    public static String closedPath(Point2D.Double first, Point2D.Double ... rest) {
        return String.valueOf(PSUtility.path(first, rest)) + " closepath ";
    }

    public static String xy(Point2D.Double point) {
        return String.format("%f %f ", point.x, point.y);
    }
}

