/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.ps;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.ps.PSUtility;
import edu.iu.sci2.visualization.geomaps.viz.ps.PostScriptable;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collection;

public class PageHeader
implements PostScriptable {
    private static final Predicate<String> IS_NULL_OR_EMPTY = new Predicate<String>(){

        public boolean apply(String input) {
            return Strings.isNullOrEmpty((String)input);
        }
    };
    public static final double TITLE_FONT_BRIGHTNESS = 0.0;
    public static final double OTHER_DATA_FONT_BRIGHTNESS = 0.0;
    private final String title;
    private final Point2D.Double lowerLeft;
    private final PageLayout pageLayout;
    private final Collection<String> extraInfo;

    public PageHeader(String title, Point2D.Double lowerLeft, PageLayout pageLayout, String ... extraInfo) {
        this.title = title;
        this.lowerLeft = lowerLeft;
        this.pageLayout = pageLayout;
        this.extraInfo = Collections2.filter(Arrays.asList(extraInfo), (Predicate)Predicates.not(IS_NULL_OR_EMPTY));
    }

    @Override
    public String toPostScript() {
        StringBuilder builder = new StringBuilder();
        builder.append("% Page info\n");
        builder.append("gsave\n");
        builder.append("    % Show title and subtitle\n");
        builder.append("    " + this.lowerLeft.x + " " + this.lowerLeft.y + " moveto" + "\n");
        builder.append(String.valueOf(PSUtility.findscalesetfont(this.pageLayout.titleFont())) + "\n");
        builder.append(String.valueOf(PSUtility.setgray(0.0)) + "\n");
        builder.append("    gsave\n");
        builder.append("        (" + this.title + ") show" + "\n");
        builder.append("    grestore\n");
        builder.append("    % Show the rest of the info\n");
        builder.append("    0 " + -(this.pageLayout.titleFont().getSize() + 5) + " rmoveto");
        builder.append(String.valueOf(PSUtility.findscalesetfont(this.pageLayout.contentFont())) + "\n");
        builder.append(String.valueOf(PSUtility.setgray(0.0)) + "\n");
        for (String infoBit : this.extraInfo) {
            builder.append("    gsave\n");
            builder.append("        (" + infoBit + ")" + " show" + "\n");
            builder.append("    grestore\n");
            builder.append("    0 " + -(this.pageLayout.contentFont().getSize() + 5) + " rmoveto" + "\n");
        }
        builder.append("grestore\n");
        return builder.toString();
    }
}

