/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.viz.strategy;

import edu.iu.sci2.visualization.geomaps.viz.ps.PSUtility;
import edu.iu.sci2.visualization.geomaps.viz.strategy.ColorStrategy;
import java.awt.Color;

public class StrokeColorStrategy
extends ColorStrategy {
    public static final Color DEFAULT_COLOR = Color.BLACK;

    private StrokeColorStrategy(Color color) {
        this.color = color;
    }

    public static StrokeColorStrategy forColor(Color color) {
        return color == null ? StrokeColorStrategy.theDefault() : new StrokeColorStrategy(color);
    }

    public static StrokeColorStrategy theDefault() {
        return StrokeColorStrategy.forColor(DEFAULT_COLOR);
    }

    @Override
    public String toPostScript() {
        StringBuilder builder = new StringBuilder();
        builder.append("gsave\n");
        builder.append("    " + PSUtility.makeSetRGBColorCommand(this.color));
        builder.append("    stroke\n");
        builder.append("grestore\n");
        return builder.toString();
    }
}

