/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import edu.iu.sci2.visualization.scimaps.analysis.AbstractTabularAnalysis;
import edu.iu.sci2.visualization.scimaps.analysis.DisciplineAnalysis;
import edu.iu.sci2.visualization.scimaps.analysis.SubdisciplineAnalysis;
import edu.iu.sci2.visualization.scimaps.journals.JournalDataset;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import oim.vivo.scimapcore.journal.Discipline;
import oim.vivo.scimapcore.journal.Edge;
import oim.vivo.scimapcore.journal.Journal;
import oim.vivo.scimapcore.journal.Node;
import oim.vivo.scimapcore.journal.Nodes;
import oim.vivo.scimapcore.mapping.DetailedScienceMappingResult;
import oim.vivo.scimapcore.mapping.ScienceMapping;

public class MapOfScience {
    public static final DecimalFormat FORMATTER = new DecimalFormat("###,###");
    private final String dataColumnName;
    private DetailedScienceMappingResult mappingResult;

    public MapOfScience(String dataColumnName, Map<String, Integer> journalOccurrences) {
        this(dataColumnName, ScienceMapping.generateDetailedScienceMappingResult(journalOccurrences));
    }

    public MapOfScience(String dataColumnName, DetailedScienceMappingResult mappingResult) {
        this.dataColumnName = dataColumnName;
        this.mappingResult = mappingResult;
    }

    public float countOfMappedPublications() {
        return this.mappingResult.getMappedJournals().size();
    }

    public String prettyCountOfMappedPublications() {
        float count = this.countOfMappedPublications();
        return FORMATTER.format(count);
    }

    public float countOfUnmappedPublications() {
        return this.mappingResult.getUnmappedJournals().size();
    }

    public String prettyCountOfUnmappedPublications() {
        float count = this.countOfUnmappedPublications();
        return FORMATTER.format(count);
    }

    public float countOfPublications() {
        return this.mappingResult.getJournals().size();
    }

    public String prettyCountOfPublications() {
        float count = this.countOfPublications();
        return FORMATTER.format(count);
    }

    public float countOfMappedSubdisciplines() {
        return this.mappingResult.getMappedResult().size();
    }

    public String prettyCountOfMappedSubdisciplines() {
        float count = this.countOfMappedSubdisciplines();
        return FORMATTER.format(count);
    }

    public float countOfDisciplinesUsed() {
        HashSet<Discipline> disciplinesUsed = new HashSet<Discipline>();
        Set<Integer> usedNodeIds = this.getMappedResults().keySet();
        for (int usedNodeId : usedNodeIds) {
            Discipline nodeDiscipline = Nodes.getNodeByID((int)usedNodeId).getDiscipline();
            disciplinesUsed.add(nodeDiscipline);
        }
        return disciplinesUsed.size();
    }

    public String prettyCountOfDisciplinesUsed() {
        float count = this.countOfDisciplinesUsed();
        return FORMATTER.format(count);
    }

    public Map<Integer, Float> getMappedResults() {
        return this.mappingResult.getMappedResult();
    }

    public Map<String, Float> getUnmappedResults() {
        return this.mappingResult.getUnmappedResult();
    }

    public Collection<Float> getMappedWeights() {
        return this.getMappedResults().values();
    }

    public Set<Integer> getMappedIds() {
        return this.getMappedResults().keySet();
    }

    public List<Integer> getMappedIdsByWeight() {
        Integer[] mappedIds = this.getMappedIds().toArray(new Integer[0]);
        Arrays.sort(mappedIds, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return MapOfScience.this.getIdWeightMapping().get(o1).compareTo(MapOfScience.this.getIdWeightMapping().get(o2));
            }
        });
        return Arrays.asList(mappedIds);
    }

    public Map<Integer, Float> getIdWeightMapping() {
        return this.mappingResult.getMappedResult();
    }

    public Set<Journal> getJournals() {
        return this.mappingResult.getJournals();
    }

    public static Set<Edge> getEdges() {
        return ScienceMapping.getEdges();
    }

    public static Set<Discipline> getDisciplines() {
        return ScienceMapping.getDisciplines();
    }

    public static Set<Node> getNodes() {
        return ScienceMapping.getNodes();
    }

    public Set<Journal> getMappedJournals() {
        return this.mappingResult.getMappedJournals();
    }

    public Set<Journal> getUnmappedJournals() {
        return this.mappingResult.getUnmappedJournals();
    }

    public SortedMap<Discipline, SortedSet<Journal>> getMappedJournalsByDiscipline() {
        return MapOfScience.getJournalsByDiscipline(this.getMappedJournals());
    }

    public SortedMap<Discipline, SortedSet<Journal>> getUnmappedJournalsByDiscipline() {
        return MapOfScience.getJournalsByDiscipline(this.getUnmappedJournals());
    }

    public static SortedMap<Discipline, SortedSet<Journal>> getJournalsByDiscipline(Set<Journal> journals) {
        TreeMap<Discipline, SortedSet<Journal>> disciplinesByJournal = new TreeMap<Discipline, SortedSet<Journal>>();
        for (Journal journal : journals) {
            Discipline discipline = journal.getJournalDiscipline();
            TreeSet<Journal> journalsForDiscipline = (TreeSet<Journal>)disciplinesByJournal.get(discipline);
            if (journalsForDiscipline == null) {
                journalsForDiscipline = new TreeSet<Journal>();
                journalsForDiscipline.add(journal);
            } else {
                journalsForDiscipline.add(journal);
            }
            disciplinesByJournal.put(discipline, journalsForDiscipline);
        }
        return disciplinesByJournal;
    }

    public String getDataColumnName() {
        return this.dataColumnName;
    }

    public AbstractTabularAnalysis<Discipline> createDisciplineAnalysis(JournalDataset journalOccurrences) {
        ImmutableMultiset.Builder journalOccurrencesPerDiscipline = ImmutableMultiset.builder();
        Iterable allUniqueJournalsByDiscipline = Iterables.concat(this.getMappedJournalsByDiscipline().entrySet(), this.getUnmappedJournalsByDiscipline().entrySet());
        for (Map.Entry entry : allUniqueJournalsByDiscipline) {
            Discipline discipline = (Discipline)entry.getKey();
            ImmutableSet<JournalDataset.Journal> disciplineJournals = JournalDataset.Journal.forVivoCoreJournals((Iterable)entry.getValue());
            journalOccurrencesPerDiscipline.setCount((Object)discipline, journalOccurrences.totalCount((Set<JournalDataset.Journal>)disciplineJournals));
        }
        return new DisciplineAnalysis((Multiset<Discipline>)journalOccurrencesPerDiscipline.build());
    }

    public AbstractTabularAnalysis<SubdisciplineAnalysis.Subdiscipline> createSubdisciplineAnalysis(JournalDataset journalOccurrences) {
        ImmutableSortedMap.Builder journalDistributionPerSubdiscipline = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<Integer, Float> entry : this.getIdWeightMapping().entrySet()) {
            journalDistributionPerSubdiscipline.put((Object)SubdisciplineAnalysis.Subdiscipline.forID(entry.getKey()), (Object)entry.getValue());
        }
        ImmutableSet<JournalDataset.Journal> unmappedJournals = JournalDataset.Journal.forVivoCoreJournals(this.getUnmappedJournals());
        int unmappedJournalOccurrencesCount = journalOccurrences.totalCount((Set<JournalDataset.Journal>)unmappedJournals);
        return new SubdisciplineAnalysis((SortedMap<SubdisciplineAnalysis.Subdiscipline, Float>)journalDistributionPerSubdiscipline.build(), unmappedJournalOccurrencesCount);
    }
}

