/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.iu.sci2.visualization.scimaps.analysis.table.Column;
import edu.iu.sci2.visualization.scimaps.analysis.table.Row;
import java.util.Set;
import prefuse.data.Table;

public abstract class AbstractTabularAnalysis<E> {
    private final ImmutableSet<? extends Column<?>> columns;

    protected AbstractTabularAnalysis(Set<? extends Column<?>> columns) {
        Preconditions.checkNotNull(columns);
        this.columns = ImmutableSet.copyOf(columns);
    }

    protected abstract Iterable<E> getElements();

    protected abstract Row createRowFor(E var1);

    protected Iterable<Row> createAdditionalRows() {
        return ImmutableList.of();
    }

    public Table copyAsTable() {
        Table table = Column.buildSchemaFor(this.columns).instantiate();
        for (E element : this.getElements()) {
            this.createRowFor(element).addAsNewRowToTable(table);
        }
        for (Row row : this.createAdditionalRows()) {
            row.addAsNewRowToTable(table);
        }
        return table;
    }
}

