/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multiset;
import edu.iu.sci2.visualization.scimaps.analysis.AbstractTabularAnalysis;
import edu.iu.sci2.visualization.scimaps.analysis.table.Column;
import edu.iu.sci2.visualization.scimaps.analysis.table.Row;
import java.util.Collection;
import java.util.Set;
import oim.vivo.scimapcore.journal.Discipline;
import oim.vivo.scimapcore.journal.Disciplines;

public class DisciplineAnalysis
extends AbstractTabularAnalysis<Discipline> {
    public static final Column<String> NAME = Column.create(String.class, "Discipline");
    public static final Column<Integer> TOTAL = Column.create(Integer.class, "Journal Occurrences");
    private final ImmutableMultiset<Discipline> disciplineTotals;

    public DisciplineAnalysis(Multiset<Discipline> disciplines) {
        super((Set<? extends Column<?>>)ImmutableSet.of(NAME, TOTAL));
        Preconditions.checkNotNull(disciplines);
        this.disciplineTotals = ImmutableMultiset.copyOf(disciplines);
    }

    @Override
    protected Iterable<Discipline> getElements() {
        ImmutableSortedSet disciplines = ImmutableSortedSet.copyOf((Collection)Disciplines.getDisciplines());
        return disciplines;
    }

    @Override
    protected Row createRowFor(Discipline discipline) {
        return new Row().put(NAME, discipline.getName()).put(TOTAL, this.disciplineTotals.count((Object)discipline));
    }
}

