/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.analysis;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import edu.iu.sci2.visualization.scimaps.analysis.AbstractTabularAnalysis;
import edu.iu.sci2.visualization.scimaps.analysis.table.Column;
import edu.iu.sci2.visualization.scimaps.analysis.table.Row;
import java.util.Set;
import java.util.SortedMap;
import oim.vivo.scimapcore.journal.Node;
import oim.vivo.scimapcore.journal.Nodes;

public class SubdisciplineAnalysis
extends AbstractTabularAnalysis<Subdiscipline> {
    public static final Column<Integer> ID = Column.create(Integer.class, "Subdiscipline ID");
    public static final Column<String> DESCRIPTION = Column.create(String.class, "Description");
    public static final Column<Float> TOTAL = Column.create(Float.class, "Journal Occurrences Distributed");
    private final ImmutableSortedMap<Subdiscipline, Float> subdisciplineTotals;
    private final int unmappedTotal;

    public SubdisciplineAnalysis(SortedMap<Subdiscipline, Float> subdisciplineTotals, int unmappedTotal) {
        super((Set<? extends Column<?>>)ImmutableSet.of(ID, DESCRIPTION, TOTAL));
        Preconditions.checkNotNull(subdisciplineTotals);
        this.subdisciplineTotals = ImmutableSortedMap.copyOfSorted(subdisciplineTotals);
        this.unmappedTotal = unmappedTotal;
    }

    @Override
    protected Iterable<Subdiscipline> getElements() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        Set nodeSet = Nodes.getNodes();
        for (Node node : nodeSet) {
            builder.add((Object)Subdiscipline.forNode(node));
        }
        return builder.build();
    }

    @Override
    protected Row createRowFor(Subdiscipline subdiscipline) {
        return new Row().put(ID, subdiscipline.getId()).put(DESCRIPTION, subdiscipline.getName()).put(TOTAL, Float.valueOf(this.getTotalOrZero(subdiscipline)));
    }

    private float getTotalOrZero(Subdiscipline subdiscipline) {
        return this.subdisciplineTotals.containsKey((Object)subdiscipline) ? ((Float)this.subdisciplineTotals.get((Object)subdiscipline)).floatValue() : 0.0f;
    }

    @Override
    protected Iterable<Row> createAdditionalRows() {
        Row unmappedRow = new Row().put(ID, null).put(DESCRIPTION, "Unmapped").put(TOTAL, Float.valueOf(this.unmappedTotal));
        return ImmutableList.of((Object)unmappedRow);
    }

    public static class Subdiscipline
    implements Comparable<Subdiscipline> {
        private final Node node;

        private Subdiscipline(Node node) {
            this.node = (Node)Preconditions.checkNotNull((Object)node);
        }

        private static Subdiscipline forNode(Node node) {
            Preconditions.checkNotNull((Object)node);
            return new Subdiscipline(node);
        }

        public static Subdiscipline forID(int id) {
            Node node = Nodes.getNodeByID((int)id);
            Preconditions.checkArgument((node != null ? 1 : 0) != 0, (String)"No subdiscipline with ID %s.", (Object[])new Object[]{id});
            return Subdiscipline.forNode(node);
        }

        public int getId() {
            return this.node.getId();
        }

        public String getName() {
            return this.node.getName();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("node", (Object)this.node).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.node.getId()});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Subdiscipline)) {
                return false;
            }
            Subdiscipline that = (Subdiscipline)o;
            return Objects.equal((Object)this.node.getId(), (Object)that.node.getId());
        }

        @Override
        public int compareTo(Subdiscipline that) {
            return Integer.valueOf(this.node.getId()).compareTo(that.node.getId());
        }
    }
}

