/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.analysis.table;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Set;
import prefuse.data.Schema;

public class Column<T>
implements Comparable<Column<?>> {
    private final Class<T> clazz;
    private final String name;

    private Column(Class<T> clazz, String name) {
        this.clazz = clazz;
        this.name = name;
    }

    public static <T> Column<T> create(Class<T> clazz, String name) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull((Object)name);
        return new Column<T>(clazz, name);
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("clazz", this.clazz).add("name", (Object)this.name).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column that = (Column)o;
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    @Override
    public int compareTo(Column<?> that) {
        return this.name.compareTo(that.name);
    }

    public static Schema buildSchemaFor(Set<? extends Column<?>> columns) {
        Preconditions.checkNotNull(columns);
        Schema s = new Schema(columns.size());
        for (Column<?> column : columns) {
            s.addColumn(column.getName(), column.getClazz());
        }
        return s.lockSchema();
    }
}

