/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.analysis.table;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import edu.iu.sci2.visualization.scimaps.analysis.table.Column;
import java.util.Map;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;

public class Row {
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on((String)";").withKeyValueSeparator(": ").useForNull(String.valueOf(null));
    private final Map<Column<?>, Object> columnValues = Maps.newHashMap();

    public int size() {
        return this.columnValues.size();
    }

    public <T> Row put(Column<T> column, T value) {
        Preconditions.checkNotNull(column, (Object)"column null");
        if (column.getClazz().isPrimitive() && value == null) {
            throw new NullPointerException(String.format("Cannot set null value on primitive column %s.", column));
        }
        Preconditions.checkState((!this.columnValues.containsKey(column) ? 1 : 0) != 0, (String)"Duplicate setting %s for column %s; value %s is already set.", (Object[])new Object[]{value, column, this.columnValues.get(column)});
        this.columnValues.put(column, value);
        return this;
    }

    public void copyIntoTuple(Tuple tuple) {
        Schema impliedSchema = Column.buildSchemaFor(this.columnValues.keySet());
        Schema targetSchema = tuple.getSchema();
        Preconditions.checkState((boolean)impliedSchema.isAssignableFrom(targetSchema), (String)"The schema (%s) implied by this entry's columnValues (%s) is not assignable from the target schema (%s).", (Object[])new Object[]{impliedSchema, MAP_JOINER.join(this.columnValues), targetSchema});
        Preconditions.checkState((boolean)targetSchema.isAssignableFrom(impliedSchema), (String)"The target schema (%s) is not assignable from the schema (%s) implied by this entry's columnValues (%s).", (Object[])new Object[]{targetSchema, impliedSchema, MAP_JOINER.join(this.columnValues)});
        for (Map.Entry<Column<?>, Object> entry : this.columnValues.entrySet()) {
            Column<?> column = entry.getKey();
            Object value = entry.getValue();
            Preconditions.checkArgument((boolean)tuple.canSet(column.getName(), column.getClazz()), (String)"Cannot set value %s in column %s of tuple %s.", (Object[])new Object[]{value, column, tuple});
            tuple.set(column.getName(), value);
        }
    }

    public void addAsNewRowToTable(Table table) {
        this.copyIntoTuple(table.getTuple(table.addRow()));
    }
}

