/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.fields;

import edu.iu.sci2.visualization.scimaps.fields.FieldsMapAlgorithm;
import edu.iu.sci2.visualization.scimaps.rendering.Layout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.utilities.AlgorithmUtilities;
import org.cishell.utilities.MutateParameterUtilities;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Schema;
import prefuse.data.Table;

public class FieldsMapAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String NODE_ID_COLUMN_NAME_ID = "nodeIDColumnName";
    public static final String NODE_LABEL_COLUMN_NAME_ID = "nodeLabelColumnName";
    public static final String NODE_VALUE_COLUMN_NAME_ID = "nodeValueColumnName";
    public static final String NO_VALUE_COLUMN_TOKEN = "[None -- All Equal]";
    public static final String SUBTITLE_ID = "subtitle";
    public static final String SCALING_FACTOR_ID = "scalingFactor";
    public static final String WEB_VERSION_ID = "webVersion";
    public static final String SHOW_WINDOW_ID = "showWindow";
    public static final String DEFAULT_SUBTITLE_PREFIX = "Generated from ";

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        LogService logger = (LogService)context.getService(LogService.class.getName());
        String nodeIDColumnName = (String)parameters.get(NODE_ID_COLUMN_NAME_ID);
        String nodeLabelColumnName = (String)parameters.get(NODE_LABEL_COLUMN_NAME_ID);
        String nodeValueColumnName = (String)parameters.get(NODE_VALUE_COLUMN_NAME_ID);
        String dataDisplayName = (String)parameters.get(SUBTITLE_ID);
        float scalingFactor = ((Float)parameters.get(SCALING_FACTOR_ID)).floatValue();
        boolean webVersion = (Boolean)parameters.get(WEB_VERSION_ID);
        Layout layout = webVersion ? Layout.SIMPLE : Layout.FULL;
        boolean showWindow = (Boolean)parameters.get(SHOW_WINDOW_ID);
        return new FieldsMapAlgorithm(data, logger, nodeIDColumnName, nodeLabelColumnName, nodeValueColumnName, dataDisplayName, scalingFactor, layout, showWindow);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        Table table = (Table)data[0].getData();
        List columnNames = TableUtilities.getAllColumnNames((Schema)table.getSchema());
        ObjectClassDefinition newParameters = FieldsMapAlgorithmFactory.addSourceDataFilenameParameter(oldParameters, data);
        newParameters = MutateParameterUtilities.mutateToDropdown((ObjectClassDefinition)newParameters, (String)NODE_ID_COLUMN_NAME_ID, (Collection)columnNames, (Collection)columnNames);
        newParameters = MutateParameterUtilities.mutateToDropdown((ObjectClassDefinition)newParameters, (String)NODE_LABEL_COLUMN_NAME_ID, (Collection)columnNames, (Collection)columnNames);
        ArrayList<String> columnNamesWithNone = new ArrayList<String>(columnNames);
        columnNamesWithNone.add(NO_VALUE_COLUMN_TOKEN);
        newParameters = MutateParameterUtilities.mutateToDropdown((ObjectClassDefinition)newParameters, (String)NODE_VALUE_COLUMN_NAME_ID, columnNamesWithNone, columnNamesWithNone);
        return FieldsMapAlgorithmFactory.mutateSubtitleParameter(newParameters, data);
    }

    private static ObjectClassDefinition mutateSubtitleParameter(ObjectClassDefinition newParameters, Data[] data) {
        String defaultSubtitle = DEFAULT_SUBTITLE_PREFIX + data[0].getMetadata().get("Label");
        return MutateParameterUtilities.mutateDefaultValue((ObjectClassDefinition)newParameters, (String)SUBTITLE_ID, (String)defaultSubtitle);
    }

    private static ObjectClassDefinition addSourceDataFilenameParameter(ObjectClassDefinition newParameters, Data[] data) {
        String guessedSourceDataFilename = AlgorithmUtilities.guessSourceDataFilename((Data)data[0]);
        return MutateParameterUtilities.mutateDefaultValue((ObjectClassDefinition)newParameters, (String)SUBTITLE_ID, (String)guessedSourceDataFilename);
    }
}

