/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.fields;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cishell.utilities.NumberUtilities;
import org.cishell.utilities.StringUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Table;
import prefuse.data.Tuple;

public class TableReader {
    public static final int MIN_UCSD_AREA = 1;
    public static final int MAX_UCSD_AREA = 554;
    private int goodRecordCount = 0;
    private int unclassifiedRecordCount = 0;
    private Map<Integer, Float> ucsdAreaTotals = new HashMap<Integer, Float>();
    private Map<Integer, String> ucsdAreaLabels = new HashMap<Integer, String>();
    private Map<String, Float> unclassifiedLabelCounts = new HashMap<String, Float>();

    public TableReader(Table table, String nodeValueColumnName, String nodeLabelColumnName, String nodeIDColumnName, LogService logger) {
        int noValueCount = 0;
        int badUCSDAreaCount = 0;
        Iterator rows = table.tuples();
        while (rows.hasNext()) {
            Tuple row = (Tuple)rows.next();
            int value = 0;
            if ("[None -- All Equal]".equals(nodeValueColumnName)) {
                value = 1;
            } else {
                try {
                    value = NumberUtilities.interpretObjectAsDouble((Object)row.get(nodeValueColumnName)).intValue();
                }
                catch (NumberFormatException e) {
                    value = 0;
                    ++noValueCount;
                    logger.log(4, e.getMessage(), (Throwable)e);
                }
                if (value < 0) {
                    ++noValueCount;
                    continue;
                }
            }
            String label = StringUtilities.interpretObjectAsString((Object)row.get(nodeLabelColumnName));
            try {
                Object idsObject = row.get(nodeIDColumnName);
                ArrayList<Integer> ids = new ArrayList<Integer>();
                if (idsObject instanceof String) {
                    String[] idStrings;
                    String idsString = (String)idsObject;
                    String[] stringArray = idStrings = idsString.split("\\D");
                    int n = idStrings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String idString = stringArray[n2];
                        if (idString.trim().length() > 0) {
                            ids.add(Integer.valueOf(idString.trim()));
                        }
                        ++n2;
                    }
                } else {
                    int id = NumberUtilities.interpretObjectAsDouble((Object)idsObject).intValue();
                    ids.add(id);
                }
                float normalizedValue = (float)value / (float)ids.size();
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    int ucsdArea = (Integer)iterator.next();
                    if (label == null || label.trim().length() == 0) {
                        label = "Area " + String.valueOf(ucsdArea);
                    }
                    String oldLabel = "";
                    if (this.ucsdAreaLabels.containsKey(ucsdArea)) {
                        oldLabel = String.valueOf(this.ucsdAreaLabels.get(ucsdArea).trim()) + "; ";
                    }
                    if (!oldLabel.contains(label)) {
                        this.ucsdAreaLabels.put(ucsdArea, String.valueOf(oldLabel) + label);
                    }
                    if (1 <= ucsdArea && ucsdArea <= 554) {
                        float oldValue = 0.0f;
                        if (this.ucsdAreaTotals.containsKey(ucsdArea)) {
                            oldValue = this.ucsdAreaTotals.get(ucsdArea).floatValue();
                        }
                        this.ucsdAreaTotals.put(ucsdArea, Float.valueOf(oldValue + normalizedValue));
                        ++this.goodRecordCount;
                        continue;
                    }
                    ++badUCSDAreaCount;
                }
            }
            catch (NumberFormatException e) {
                if (label == null || label.trim().length() == 0) {
                    label = "Unidentified Area";
                }
                float oldValue = 0.0f;
                if (this.unclassifiedLabelCounts.containsKey(label)) {
                    oldValue = this.unclassifiedLabelCounts.get(label).floatValue();
                }
                this.unclassifiedLabelCounts.put(label, Float.valueOf(oldValue + (float)value));
                ++this.unclassifiedRecordCount;
                logger.log(4, e.getMessage(), (Throwable)e);
            }
        }
        if (badUCSDAreaCount > 0) {
            logger.log(2, String.valueOf(noValueCount) + " records specified an invalid UCSD area and were skipped.");
        }
        if (noValueCount > 0) {
            logger.log(2, String.valueOf(noValueCount) + " records specified no valid value and were treated as specifying zero.");
        }
    }

    public int getGoodRecordCount() {
        return this.goodRecordCount;
    }

    public int getUnclassifiedRecordCount() {
        return this.unclassifiedRecordCount;
    }

    public Map<Integer, Float> getUcsdAreaTotals() {
        return this.ucsdAreaTotals;
    }

    public Map<Integer, String> getUcsdAreaLabels() {
        return this.ucsdAreaLabels;
    }

    public Map<String, Float> getUnclassifiedLabelCounts() {
        return this.unclassifiedLabelCounts;
    }
}

