/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.journals;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.osgi.service.log.LogService;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleSet;

public final class JournalDataset {
    private final ImmutableMultiset<Journal> journals;

    private JournalDataset(Multiset<Journal> journals) {
        this.journals = ImmutableMultiset.copyOf(journals);
    }

    public static JournalDataset forJournals(Multiset<Journal> journals) {
        Preconditions.checkNotNull(journals);
        return new JournalDataset(journals);
    }

    public static JournalDataset fromTable(Table table, String journalColumnName, LogService logger) {
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkNotNull((Object)journalColumnName);
        Preconditions.checkArgument((boolean)table.canGetString(journalColumnName), (String)"Cannot get String values from column %s of table %s.", (Object[])new Object[]{journalColumnName, table});
        TableReader tableReader = new TableReader((TupleSet)table, journalColumnName);
        if (logger != null) {
            tableReader.logWarningsTo(logger);
        }
        return JournalDataset.forJournals(tableReader.buildJournals());
    }

    public boolean isEmpty() {
        return this.journals.isEmpty();
    }

    public int size() {
        return this.journals.size();
    }

    public int count(Journal journal) {
        return this.journals.count((Object)journal);
    }

    public int totalCount(Set<Journal> journals) {
        Preconditions.checkNotNull(journals);
        int totalCount = 0;
        for (Journal journal : journals) {
            totalCount += this.count(journal);
        }
        return totalCount;
    }

    public ImmutableSet<Journal> distinctJournals() {
        return ImmutableSet.copyOf((Collection)this.journals.elementSet());
    }

    public ImmutableMap<String, Integer> copyAsIdentifierCountMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Multiset.Entry entry : this.journals.entrySet()) {
            builder.put((Object)((Journal)entry.getElement()).getIdentifier(), (Object)entry.getCount());
        }
        return builder.build();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("journals", this.journals).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.journals});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof JournalDataset)) {
            return false;
        }
        JournalDataset that = (JournalDataset)o;
        return Objects.equal(this.journals, that.journals);
    }

    public static final class Journal {
        private final String identifier;

        private Journal(String identifier) {
            this.identifier = identifier;
        }

        public static Journal forName(String name) {
            Preconditions.checkNotNull((Object)name);
            String normalized = name.trim().toLowerCase();
            return new Journal(normalized);
        }

        public static Journal forVivoCoreJournal(oim.vivo.scimapcore.journal.Journal vivoCoreJournal) {
            return Journal.forName(vivoCoreJournal.getJournalName());
        }

        public static ImmutableSet<Journal> forVivoCoreJournals(Iterable<? extends oim.vivo.scimapcore.journal.Journal> vivoCoreJournals) {
            ImmutableSet.Builder datasetJournals = ImmutableSet.builder();
            for (oim.vivo.scimapcore.journal.Journal journal : vivoCoreJournals) {
                datasetJournals.add((Object)Journal.forVivoCoreJournal(journal));
            }
            return datasetJournals.build();
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("identifier", (Object)this.identifier).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.identifier});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Journal)) {
                return false;
            }
            Journal that = (Journal)o;
            return Objects.equal((Object)this.identifier, (Object)that.identifier);
        }
    }

    private static class TableReader {
        private final TupleSet table;
        private final String journalColumnName;
        private final ImmutableMultiset.Builder<Journal> builder;
        private int nullCount;

        TableReader(TupleSet tupleSet, String journalColumnName) {
            this.table = tupleSet;
            this.journalColumnName = journalColumnName;
            this.builder = ImmutableMultiset.builder();
            this.nullCount = 0;
            this.readTable();
        }

        void logWarningsTo(LogService logger) {
            if (this.nullCount > 0) {
                logger.log(2, String.format("Skipped %d rows with missing journal identifiers.", this.nullCount));
            }
        }

        ImmutableMultiset<Journal> buildJournals() {
            return this.builder.build();
        }

        private void readTable() {
            Iterator rows = this.table.tuples();
            while (rows.hasNext()) {
                this.readRow((Tuple)rows.next());
            }
        }

        private void readRow(Tuple row) {
            assert (row.canGetString(this.journalColumnName)) : "TableReader can only be constructed via JournalDataset.fromTable, which fails if it cannot get Strings from this column of the table as a whole.";
            String journalName = row.getString(this.journalColumnName);
            if (journalName == null) {
                ++this.nullCount;
                return;
            }
            this.builder.add((Object)Journal.forName(journalName.trim()));
        }
    }
}

