/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.journals;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import edu.iu.sci2.visualization.scimaps.MapOfScience;
import edu.iu.sci2.visualization.scimaps.journals.JournalDataset;
import edu.iu.sci2.visualization.scimaps.rendering.AbstractRenderablePageManager;
import edu.iu.sci2.visualization.scimaps.rendering.Layout;
import edu.iu.sci2.visualization.scimaps.tempvis.AbstractPageManager;
import edu.iu.sci2.visualization.scimaps.tempvis.GraphicsState;
import edu.iu.sci2.visualization.scimaps.tempvis.VisualizationRunner;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oim.vivo.scimapcore.journal.Journal;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.util.UserProperties;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class JournalsMapAlgorithm
implements Algorithm {
    public static final boolean RESOLVE_JOURNALS_TO_CANONICAL_NAME = false;
    public static final boolean INCLUDE_DISTRIBUTION_TABLE_OUTPUT_DATA = false;
    public static final String OUT_FREQUENCY_COLUMN_NAME = "Frequency";
    public static final String OUT_JOURNAL_COLUMN_NAME = "Journal name";
    public static final String POSTSCRIPT_MIME_TYPE = "file:text/ps";
    public static final String CSV_MIME_TYPE = "file:text/csv";
    private final Data parentData;
    private final Table table;
    private final String journalColumnName;
    private final float scalingFactor;
    private final String dataDisplayName;
    private final Layout layout;
    private final boolean showWindow;
    private final LogService logger;

    public JournalsMapAlgorithm(Data[] data, String journalColumnName, float scalingFactor, String dataDisplayName, Layout layout, boolean showWindow, LogService logger) {
        this.parentData = data[0];
        this.table = (Table)data[0].getData();
        this.journalColumnName = journalColumnName;
        this.scalingFactor = scalingFactor;
        this.dataDisplayName = dataDisplayName;
        this.layout = layout;
        this.showWindow = showWindow;
        this.logger = logger;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        JournalDataset dataset = JournalDataset.fromTable(this.table, this.journalColumnName, this.logger);
        this.logger.log(3, String.format("Loaded %d occurrences of %d distinct journals.", dataset.size(), dataset.distinctJournals().size()));
        if (dataset.isEmpty()) {
            throw new AlgorithmExecutionException("No journals could be found in the data.");
        }
        MapOfScience mapOfScience = new MapOfScience("Fractional record count", (Map<String, Integer>)dataset.copyAsIdentifierCountMap());
        if (mapOfScience.getMappedResults().isEmpty()) {
            throw new AlgorithmExecutionException("No journals could be mapped to the Map of Science.");
        }
        AbstractRenderablePageManager manager = this.layout.createPageManager(mapOfScience, this.scalingFactor, this.dataDisplayName);
        if (this.showWindow) {
            VisualizationRunner visualizationRunner = new VisualizationRunner(manager);
            visualizationRunner.setUp();
            visualizationRunner.run();
        }
        return JournalsMapAlgorithm.datafy(mapOfScience, manager, dataset, this.parentData, this.logger);
    }

    public static Data[] datafy(MapOfScience mapOfScience, AbstractPageManager pageManager, JournalDataset journalOccurrences, Data parentData, LogService logger) {
        ArrayList outData = Lists.newArrayList();
        Set<Journal> foundJournals = mapOfScience.getMappedJournals();
        Table foundTable = JournalsMapAlgorithm.makeJournalFrequencyTable((Set<Journal>)ImmutableSet.copyOf(foundJournals));
        outData.add(JournalsMapAlgorithm.datafy(foundTable, "Journals located", parentData));
        Set<Journal> unfoundJournals = mapOfScience.getUnmappedJournals();
        Table unfoundTable = JournalsMapAlgorithm.makeJournalFrequencyTable((Set<Journal>)ImmutableSet.copyOf(unfoundJournals));
        outData.add(JournalsMapAlgorithm.datafy(unfoundTable, "Journals not located", parentData));
        try {
            Data visualizationData = JournalsMapAlgorithm.createData(pageManager, parentData, logger);
            outData.add(visualizationData);
        }
        catch (DataCreationException e) {
            logger.log(1, e.getMessage());
        }
        return outData.toArray(new Data[0]);
    }

    private static Data createData(AbstractPageManager pageManager, Data parentData, LogService logger) throws DataCreationException {
        try {
            File outFile = File.createTempFile("MapOfScience_Visualization_", ".ps");
            FileOutputStream out = new FileOutputStream(outFile);
            JournalsMapAlgorithm.writePostscript(pageManager, out, logger);
            ((OutputStream)out).close();
            File hackOutFile = JournalsMapAlgorithm.hackPageSizeForFreehepAndAdobe(outFile, pageManager);
            BasicData outData = new BasicData((Object)hackOutFile, POSTSCRIPT_MIME_TYPE);
            Dictionary metadata = outData.getMetadata();
            metadata.put("Label", "Map of Science Visualization");
            metadata.put("Type", "Vector Image");
            metadata.put("Parent", parentData);
            return outData;
        }
        catch (IOException e) {
            throw new DataCreationException("There was a problem creating the postscript file", e);
        }
    }

    private static File hackPageSizeForFreehepAndAdobe(File psFile, AbstractPageManager pageManager) throws IOException {
        String line;
        File outFile = File.createTempFile("MapOfScience_Visualization_", ".ps");
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        BufferedReader reader = new BufferedReader(new FileReader(psFile));
        String newline = System.getProperty("line.separator");
        String MAGIC_WORDS = "%%BeginFeature: *PageSize Default\n<< /PageSize [ " + pageManager.pageDimensions().getWidth() + " " + pageManager.pageDimensions().getHeight() + " ] >> setpagedevice\n%%EndFeature";
        while ((line = reader.readLine()) != null) {
            out.write(String.valueOf(line) + newline);
            if (!line.contains("%%EndComments")) continue;
            out.write(String.valueOf(MAGIC_WORDS) + newline);
        }
        reader.close();
        out.close();
        return outFile;
    }

    private static void writePostscript(AbstractPageManager pageManager, OutputStream out, LogService logger) throws IOException {
        UserProperties psProperties = new UserProperties();
        psProperties.setProperty(PSGraphics2D.EMBED_FONTS, false);
        psProperties.setProperty(AbstractVectorGraphicsIO.TEXT_AS_SHAPES, false);
        psProperties.setProperty(PSGraphics2D.FIT_TO_PAGE, false);
        psProperties.setProperty(PSGraphics2D.PAGE_SIZE, PSGraphics2D.CUSTOM_PAGE_SIZE);
        psProperties.setProperty(PSGraphics2D.CUSTOM_PAGE_SIZE, pageManager.pageDimensions());
        psProperties.setProperty(PSGraphics2D.PAGE_MARGINS, new Insets(0, 0, 0, 0));
        PSGraphics2D psGraphic = new PSGraphics2D(out, pageManager.pageDimensions());
        psGraphic.setProperties((Properties)psProperties);
        psGraphic.setMultiPage(true);
        psGraphic.startExport();
        int pageNumber = 0;
        while (pageNumber < pageManager.numberOfPages()) {
            try {
                psGraphic.openPage(pageManager.pageDimensions(), "Page " + (pageNumber + 1));
                psGraphic.setClip(0, 0, (int)pageManager.pageDimensions().getWidth(), (int)pageManager.pageDimensions().getHeight());
                pageManager.render(pageNumber, new GraphicsState((Graphics2D)psGraphic));
                psGraphic.closePage();
            }
            catch (AbstractPageManager.PageManagerRenderingException e) {
                logger.log(1, e.getMessage(), (Throwable)e);
            }
            ++pageNumber;
        }
        psGraphic.endExport();
    }

    private static Data datafy(Table table, String label, Data parentData) {
        BasicData tableData = new BasicData((Object)table, table.getClass().getName());
        tableData.getMetadata().put("Label", label);
        tableData.getMetadata().put("Type", "Table");
        tableData.getMetadata().put("Parent", parentData);
        return tableData;
    }

    public static Table makeJournalFrequencyTable(Set<Journal> journals) {
        Table table = new Table();
        table.addColumn(OUT_JOURNAL_COLUMN_NAME, String.class);
        table.addColumn(OUT_FREQUENCY_COLUMN_NAME, Integer.TYPE);
        for (Journal journal : journals) {
            int row = table.addRow();
            table.setString(row, OUT_JOURNAL_COLUMN_NAME, journal.getJournalName());
            table.setInt(row, OUT_FREQUENCY_COLUMN_NAME, (int)journal.getJournalHitCount());
        }
        return table;
    }

    public static class DataCreationException
    extends Exception {
        private static final long serialVersionUID = 3544771808601245002L;

        public DataCreationException(String message) {
            super(message);
        }

        public DataCreationException(String string, Exception e) {
            super(string, e);
        }
    }
}

