/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.journals;

import edu.iu.sci2.visualization.scimaps.journals.JournalsMapAlgorithm;
import edu.iu.sci2.visualization.scimaps.rendering.Layout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.utilities.AlgorithmUtilities;
import org.cishell.utilities.ColumnNotFoundException;
import org.cishell.utilities.MutateParameterUtilities;
import org.cishell.utilities.TableUtilities;
import org.cishell.utilities.mutateParameter.dropdown.DropdownMutator;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Table;

public class JournalsMapAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String JOURNAL_COLUMN_ID = "journalColumn";
    public static final String SUBTITLE_ID = "subtitle";
    public static final String SCALING_FACTOR_ID = "scalingFactor";
    public static final String WEB_VERSION_ID = "webVersion";
    public static final String SHOW_EXPORT_WINDOW = "showWindow";
    public static final String DEFAULT_SUBTITLE_PREFIX = "Generated from ";

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        String journalColumnName = (String)parameters.get(JOURNAL_COLUMN_ID);
        float scalingFactor = ((Float)parameters.get(SCALING_FACTOR_ID)).floatValue();
        String dataDisplayName = (String)parameters.get(SUBTITLE_ID);
        boolean webVersion = (Boolean)parameters.get(WEB_VERSION_ID);
        Layout layout = webVersion ? Layout.SIMPLE : Layout.FULL;
        boolean showWindow = (Boolean)parameters.get(SHOW_EXPORT_WINDOW);
        LogService logger = (LogService)context.getService(LogService.class.getName());
        return new JournalsMapAlgorithm(data, journalColumnName, scalingFactor, dataDisplayName, layout, showWindow, logger);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        Table table = (Table)data[0].getData();
        ObjectClassDefinition paramsWithJournal = JournalsMapAlgorithmFactory.addJournalColumnDropdownParameter(oldParameters, table);
        ObjectClassDefinition paramsWithJournalAndFilename = JournalsMapAlgorithmFactory.addSourceDataFilenameParameter(paramsWithJournal, data);
        return JournalsMapAlgorithmFactory.mutateSubtitleParameter(paramsWithJournalAndFilename, data);
    }

    private static ObjectClassDefinition addJournalColumnDropdownParameter(ObjectClassDefinition oldParameters, Table table) {
        ArrayList<String> goodColumnNames = new ArrayList<String>();
        boolean hasStringColumn = true;
        try {
            goodColumnNames.addAll(Arrays.asList(TableUtilities.getValidStringColumnNamesInTable((Table)table)));
        }
        catch (ColumnNotFoundException columnNotFoundException) {
            hasStringColumn = false;
        }
        if (hasStringColumn || !goodColumnNames.isEmpty()) {
            Collections.sort(goodColumnNames, Collections.reverseOrder(new Journalishness()));
            DropdownMutator mutator = new DropdownMutator();
            mutator.add(JOURNAL_COLUMN_ID, goodColumnNames);
            return mutator.mutate(oldParameters);
        }
        String message = "Table contains no string or integer columns, so there is no candidate for a column containing journal identifiers.";
        throw new AlgorithmCreationFailedException(message);
    }

    private static ObjectClassDefinition addSourceDataFilenameParameter(ObjectClassDefinition newParameters, Data[] data) {
        String guessedSourceDataFilename = AlgorithmUtilities.guessSourceDataFilename((Data)data[0]);
        return MutateParameterUtilities.mutateDefaultValue((ObjectClassDefinition)newParameters, (String)SUBTITLE_ID, (String)guessedSourceDataFilename);
    }

    private static ObjectClassDefinition mutateSubtitleParameter(ObjectClassDefinition newParameters, Data[] data) {
        String defaultSubtitle = DEFAULT_SUBTITLE_PREFIX + data[0].getMetadata().get("Label");
        return MutateParameterUtilities.mutateDefaultValue((ObjectClassDefinition)newParameters, (String)SUBTITLE_ID, (String)defaultSubtitle);
    }

    protected static class Journalishness
    implements Comparator<String> {
        protected Journalishness() {
        }

        @Override
        public int compare(String left, String right) {
            return new Integer(Journalishness.score(left)).compareTo(Journalishness.score(right));
        }

        private static int score(String columnName) {
            String normalColumnName = columnName.toLowerCase();
            if (normalColumnName.contains("journal")) {
                if (normalColumnName.contains("name") || normalColumnName.contains("title")) {
                    if (normalColumnName.contains("full")) {
                        return 100;
                    }
                    return 50;
                }
                return 4;
            }
            if (normalColumnName.contains("period")) {
                return 3;
            }
            if (normalColumnName.startsWith("j")) {
                return 1;
            }
            return 0;
        }
    }
}

