/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.journals.canonical;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import edu.iu.sci2.visualization.scimaps.util.TextualMaps;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;

public final class CanonicalJournalForms {
    private static final ImmutableMap<String, String> CANONICAL = CanonicalJournalForms.buildMap();

    private CanonicalJournalForms() {
    }

    private static ImmutableMap<String, String> buildMap() {
        try {
            return TextualMaps.buildMapFromLinesOfEntries(Resources.newReaderSupplier((URL)Resources.getResource(CanonicalJournalForms.class, (String)"canonical.tsv"), (Charset)Charsets.UTF_8), Splitter.on((char)'\t').trimResults());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load canonical journal form lookup table.", e);
        }
    }

    public static String lookup(String journal) {
        Preconditions.checkNotNull((Object)journal);
        String normalized = journal.trim().toLowerCase();
        return CANONICAL.containsKey((Object)normalized) ? (String)CANONICAL.get((Object)normalized) : journal;
    }
}

