/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.rendering;

import edu.iu.sci2.visualization.scimaps.tempvis.GraphicsState;
import edu.iu.sci2.visualization.scimaps.tempvis.PageElement;
import java.awt.Color;
import java.text.DecimalFormat;
import oim.vivo.scimapcore.journal.Node;

public class CircleSizeLegend
implements PageElement {
    private static final DecimalFormat FORMATTER = new DecimalFormat("###,###.##");
    private float minArea;
    private float maxArea;
    private float midArea;
    private double leftBoundary;
    private double topBoundary;
    private int fontSize;
    private int titleFontSize;
    private float pageScalingFactor;
    private float scalingFactor;

    public CircleSizeLegend(float scalingFactor, float pageScalingFactor, double leftBoundary, double topBoundary, int fontSize, int titleFontSize, float minArea, float maxArea) {
        this.leftBoundary = leftBoundary;
        this.topBoundary = topBoundary;
        this.fontSize = fontSize;
        this.titleFontSize = titleFontSize;
        this.pageScalingFactor = pageScalingFactor;
        this.scalingFactor = scalingFactor;
        this.minArea = minArea;
        this.maxArea = maxArea;
        this.midArea = Math.round((double)(this.minArea + this.maxArea) / 2.0);
    }

    @Override
    public void render(GraphicsState state) {
        String title = "Area";
        state.save();
        state.current.translate(this.leftBoundary, this.topBoundary);
        double titleWidth = state.current.getFontMetrics().getStringBounds(title, state.current).getBounds().getWidth();
        state.setBoldFont("Arial", this.titleFontSize);
        state.current.drawString(title, (int)(-titleWidth), 0);
        state.restore();
        state.save();
        state.setFont("Arial", this.fontSize);
        state.current.setColor(Color.BLACK);
        state.current.translate(this.leftBoundary, this.topBoundary);
        float minRadius = Node.calculateRadius((float)this.minArea, (float)1.0f);
        float midRadius = Node.calculateRadius((float)this.midArea, (float)1.0f);
        float maxRadius = Node.calculateRadius((float)this.maxArea, (float)1.0f);
        String minLabel = FORMATTER.format(Node.calculateWeight((float)(minRadius / this.pageScalingFactor), (float)this.scalingFactor));
        String midLabel = FORMATTER.format(Node.calculateWeight((float)(midRadius / this.pageScalingFactor), (float)this.scalingFactor));
        String maxLabel = FORMATTER.format(Node.calculateWeight((float)(maxRadius / this.pageScalingFactor), (float)this.scalingFactor));
        double circleX = maxRadius;
        float maxCircleY = maxRadius * 2.0f - maxRadius;
        float midCircleY = maxRadius * 2.0f - midRadius;
        float minCircleY = maxRadius * 2.0f - minRadius;
        float labelX = 2.0f * maxRadius + 5.0f;
        float minLabelY = maxRadius * 2.0f;
        float midLabelY = (float)((double)(midCircleY - midRadius) + (double)state.current.getFontMetrics().getHeight() / 2.0);
        float maxLabelY = 0 + state.current.getFontMetrics().getHeight();
        state.drawCircle((int)circleX, (int)minCircleY, (int)minRadius);
        state.current.drawString(minLabel, labelX, minLabelY);
        state.drawCircle((int)circleX, (int)midCircleY, (int)midRadius);
        state.current.drawString(midLabel, labelX, midLabelY);
        state.drawCircle((int)circleX, (int)maxCircleY, (int)maxRadius);
        state.current.drawString(maxLabel, labelX, maxLabelY);
        state.restore();
    }
}

