/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.rendering;

import edu.iu.sci2.visualization.scimaps.tempvis.GraphicsState;
import edu.iu.sci2.visualization.scimaps.tempvis.PageElement;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;

public class ItalicCenteredFooter
implements PageElement {
    private final String footerText;
    private double topY;
    private double centerX;

    public ItalicCenteredFooter(double centerX, double topY) {
        this.centerX = centerX;
        this.topY = topY;
        this.footerText = "CNS (cns.iu.edu)";
    }

    @Override
    public void render(GraphicsState state) {
        double footerStartX;
        state.save();
        state.current.setColor(Color.gray);
        state.setItalicFont("Arial", 10);
        FontMetrics fontMetrics = state.current.getFontMetrics();
        Rectangle2D footerTextBox = fontMetrics.getStringBounds(this.footerText, state.current);
        double leftBoundary = footerStartX = this.centerX - footerTextBox.getCenterX();
        state.current.translate(leftBoundary, this.topY);
        state.current.drawString(this.footerText, 0, 0);
        state.restore();
    }
}

