/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.rendering;

import edu.iu.sci2.visualization.scimaps.tempvis.GraphicsState;
import edu.iu.sci2.visualization.scimaps.tempvis.PageElement;
import java.text.DecimalFormat;

public class PageLegend
implements PageElement {
    private static final DecimalFormat formatter = new DecimalFormat("###,###");
    private final String dataColumnName;
    private int numberOfUnclassified;
    private double minimumValue;
    private double maximumValue;
    private double leftBoundary;
    private double topBoundary;
    private int titleFontSize;
    private int normalFontSize;

    public PageLegend(String dataColumnName, int numberOfUnclassified, double minimumValue, double maximumValue, double leftBoundary, double topBoundary, int titleFontSize, int normalFontSize) {
        this.dataColumnName = dataColumnName;
        this.numberOfUnclassified = numberOfUnclassified;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.leftBoundary = leftBoundary;
        this.topBoundary = topBoundary;
        this.titleFontSize = titleFontSize;
        this.normalFontSize = normalFontSize;
    }

    @Override
    public void render(GraphicsState state) {
        state.save();
        state.current.translate(this.leftBoundary, this.topBoundary);
        String title = "Legend";
        String area = String.format("Circle area: %s", this.dataColumnName);
        String unclassified = "Unclassified = " + this.numberOfUnclassified;
        String minimum = "Minimum = " + formatter.format(this.minimumValue);
        String maximum = "Maximum = " + formatter.format(this.maximumValue);
        String color = "Color: Discipline" + System.getProperty("line.separator") + "See end of PDF for color legend.";
        state.setBoldFont("Arial", this.titleFontSize);
        state.drawStringAndTranslate(title, 0, 0);
        state.setFont("Arial", this.normalFontSize);
        state.drawStringAndTranslate(area, 0, 0);
        state.drawStringAndTranslate(unclassified, 0, 0);
        state.drawStringAndTranslate(minimum, 0, 0);
        state.drawStringAndTranslate(maximum, 0, 0);
        String[] stringArray = color.split(System.getProperty("line.separator"));
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String colorString = stringArray[n2];
            state.drawStringAndTranslate(colorString, 0, 0);
            ++n2;
        }
        state.restore();
    }
}

