/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.rendering.discipline_breakdown;

import edu.iu.sci2.visualization.scimaps.rendering.discipline_breakdown.DisciplineBreakdownAreas;
import edu.iu.sci2.visualization.scimaps.tempvis.GraphicsState;
import edu.iu.sci2.visualization.scimaps.tempvis.PageElement;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.List;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oim.vivo.scimapcore.journal.Discipline;
import oim.vivo.scimapcore.journal.Journal;

public class DisciplineBreakdownArea
implements PageElement {
    public static final int JOURNAL_SPACE = 13;
    public static final int DISCIPLINE_SPACE = 30;
    private static final int disciplineFontSize = 14;
    private static final int journalFontSize = 10;
    private static final String disciplineFont = "Arial";
    private static final String journalFont = "Arial";
    private static final int textMargin = 12;
    private static final float columnMargin = GraphicsState.inch(0.5f);
    private double width;
    private int columnsPerPage;
    private DisciplineBreakdownAreas.Page page;
    private double leftBoundary;
    private double topBoundary;

    public DisciplineBreakdownArea(DisciplineBreakdownAreas.Page page, double leftBoundary, double topBoundary) {
        this.page = page;
        this.width = (int)page.getSize().getWidth();
        this.leftBoundary = leftBoundary;
        this.topBoundary = topBoundary;
    }

    @Override
    public void render(GraphicsState state) {
        DecimalFormat formatter = new DecimalFormat("###,###");
        boolean journalSizeSanityChecked = false;
        boolean disciplineSizeSanityChecked = false;
        state.save();
        state.current.translate(this.leftBoundary, this.topBoundary);
        double columnWidth = this.width / (double)this.page.getNumberOfColumns() - (double)(columnMargin * (float)(this.columnsPerPage - 1)) - 12.0;
        List<DisciplineBreakdownAreas.Column> columns = this.page.getColumns();
        int i = 0;
        while (i < columns.size()) {
            DisciplineBreakdownAreas.Column column = columns.get(i);
            state.current.translate((columnWidth + (double)columnMargin) * (double)i, 0.0);
            state.save();
            for (DisciplineBreakdownAreas.ColumnEntry columnEntry : column.getColumnEntries()) {
                Discipline discipline = columnEntry.getDiscipline();
                SortedSet<Journal> journals = columnEntry.getJournals();
                state.setBoldFont("Arial", 14);
                if (discipline != Discipline.MULTIPLE || discipline != Discipline.NONE) {
                    state.save();
                    state.current.setPaint(discipline.getColor());
                    int boxHeight = state.current.getFontMetrics().getAscent() + state.current.getFontMetrics().getDescent();
                    state.current.fillRect(0, -boxHeight / 2, boxHeight / 2, boxHeight / 2);
                    state.restore();
                }
                state.current.translate(12, 0);
                String disciplineName = DisciplineBreakdownArea.shortenIfNeeded(discipline.getName(), state.current, columnWidth);
                state.drawStringAndTranslate(disciplineName);
                if (!disciplineSizeSanityChecked) {
                    disciplineSizeSanityChecked = true;
                    int disciplineSpace = state.current.getFontMetrics().getHeight();
                    if (30 != disciplineSpace + 13) {
                        System.err.println("The size calculated for the Discipline is wrong.  Current =30, Actual=" + disciplineSpace);
                    }
                }
                state.setFont("Arial", 10);
                for (Journal journal : journals) {
                    String journalName = DisciplineBreakdownArea.shortenIfNeeded(String.valueOf(formatter.format(journal.getJournalHitCount())) + " " + journal.getJournalName(), state.current, columnWidth);
                    Pattern journalCountNamePattern = Pattern.compile("^(\\S+) (.+)$", 8);
                    Matcher matcher = journalCountNamePattern.matcher(journalName);
                    if (matcher.matches() && matcher.groupCount() == 2) {
                        String journalHits = matcher.group(1);
                        String journalShortenedName = matcher.group(2);
                        DisciplineBreakdownArea.drawJournalHitsAndName(state, journalHits, journalShortenedName);
                    } else {
                        state.drawStringAndTranslate(journalName);
                    }
                    if (journalSizeSanityChecked) continue;
                    journalSizeSanityChecked = true;
                    int journalSpace = state.current.getFontMetrics().getHeight();
                    if (13 == journalSpace) continue;
                    System.err.println("The size calculated for the Journal is wrong.  Current =13, Actual=" + journalSpace);
                }
                state.current.translate(-12, state.current.getFontMetrics().getHeight());
            }
            state.restore();
            ++i;
        }
        state.restore();
    }

    private static void drawJournalHitsAndName(GraphicsState state, String journalHits, String journalName) {
        state.setBoldFont("Arial", 10);
        state.current.drawString(journalHits, 0, 0);
        double journalHitsWrittenWidth = state.current.getFontMetrics().getStringBounds(journalHits, state.current).getWidth();
        state.current.translate(journalHitsWrittenWidth, 0.0);
        state.setFont("Arial", 10);
        state.drawStringAndTranslate(" " + journalName);
        state.current.translate(-journalHitsWrittenWidth, 0.0);
    }

    private static String shortenIfNeeded(String string, Graphics2D g2d, double limit) {
        Rectangle2D stringBounds = g2d.getFontMetrics().getStringBounds(string, g2d);
        if (stringBounds.getWidth() <= limit) {
            return string;
        }
        String truncatationIndicator = "...";
        Rectangle2D truncationIndicatorBounds = g2d.getFontMetrics().getStringBounds(truncatationIndicator, g2d);
        int charWidth = g2d.getFontMetrics().getMaxAdvance();
        if (truncationIndicatorBounds.getWidth() + (double)charWidth >= limit) {
            return truncatationIndicator;
        }
        int numberToRemove = (int)((stringBounds.getWidth() - limit) / (double)charWidth);
        if (numberToRemove >= string.length()) {
            return truncatationIndicator;
        }
        String truncatedString = String.valueOf(string.substring(0, string.length() - numberToRemove)) + truncatationIndicator;
        while (g2d.getFontMetrics().getStringBounds(truncatedString, g2d).getWidth() > limit && numberToRemove < string.length()) {
            truncatedString = String.valueOf(string.substring(0, string.length() - ++numberToRemove)) + truncatationIndicator;
        }
        return truncatedString;
    }
}

