/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.rendering.full;

import edu.iu.sci2.visualization.scimaps.MapOfScience;
import edu.iu.sci2.visualization.scimaps.rendering.AbstractRenderablePageManager;
import edu.iu.sci2.visualization.scimaps.rendering.CenteredCopyrightInfo;
import edu.iu.sci2.visualization.scimaps.rendering.CircleSizeLegend;
import edu.iu.sci2.visualization.scimaps.rendering.HowToArea;
import edu.iu.sci2.visualization.scimaps.rendering.ItalicCenteredFooter;
import edu.iu.sci2.visualization.scimaps.rendering.PageLegend;
import edu.iu.sci2.visualization.scimaps.rendering.discipline_breakdown.DisciplineBreakdownArea;
import edu.iu.sci2.visualization.scimaps.rendering.discipline_breakdown.DisciplineBreakdownAreas;
import edu.iu.sci2.visualization.scimaps.rendering.full.Header;
import edu.iu.sci2.visualization.scimaps.rendering.scimaps.MapOfScienceRenderer;
import edu.iu.sci2.visualization.scimaps.tempvis.GraphicsState;
import java.awt.Dimension;
import java.util.Collections;

public class FullRenderablePageManager
extends AbstractRenderablePageManager {
    private final String generatedFrom;

    public FullRenderablePageManager(Dimension size, MapOfScience mapOfScience, float scalingFactor, String generatedFrom) {
        super(size, mapOfScience, scalingFactor);
        this.generatedFrom = generatedFrom;
        this.addPageIndependentElements();
        this.addPageDependentElements();
    }

    @Override
    protected void addPageIndependentElements() {
        this.addToAllPages(new Header(this.title(), this.generatedFrom, this.mapOfScience, GraphicsState.inch(0.25f), GraphicsState.inch(0.25f)));
        this.addToAllPages(new ItalicCenteredFooter(this.dimensions.getWidth() / 2.0, GraphicsState.inch(8.25f)));
    }

    @Override
    protected void addPageDependentElements() {
        int currentPage = 0;
        this.addMapOfSciencePage(0);
        ++currentPage;
        Dimension breakdownAreaSize = new Dimension((int)GraphicsState.inch(9.0f), (int)GraphicsState.inch(6.5f));
        for (DisciplineBreakdownArea breakdownArea : DisciplineBreakdownAreas.getDisciplineBreakdownAreas(breakdownAreaSize, 2, this.mapOfScience, GraphicsState.inch(0.25f), GraphicsState.inch(1.5f))) {
            this.addToPage(currentPage, breakdownArea);
            ++currentPage;
        }
    }

    @Override
    protected void addMapOfSciencePage(int pageNumber) {
        float pageScalingFactor = 1.3f;
        int fontSize = 10;
        int titleFontSize = 14;
        this.addToPage(pageNumber, new HowToArea(GraphicsState.inch(5.5f), GraphicsState.inch(7.0f)));
        this.addToPage(pageNumber, new CenteredCopyrightInfo((float)this.dimensions.getWidth() / 2.0f, GraphicsState.inch(5.72f), fontSize));
        this.addToPage(pageNumber, new CircleSizeLegend(this.scalingFactor, pageScalingFactor, GraphicsState.inch(3.47f), GraphicsState.inch(7.0f), fontSize, titleFontSize, 5.0f, 50.0f));
        this.addToPage(pageNumber, new PageLegend(this.mapOfScience.getDataColumnName(), (int)this.mapOfScience.countOfUnmappedPublications(), Collections.min(this.mapOfScience.getMappedWeights()).floatValue(), Collections.max(this.mapOfScience.getMappedWeights()).floatValue(), GraphicsState.inch(0.25f), GraphicsState.inch(7.0f), titleFontSize, fontSize));
        this.addToPage(pageNumber, new MapOfScienceRenderer(this.mapOfScience, this.scalingFactor, pageScalingFactor, GraphicsState.inch(0.0f), GraphicsState.inch(5.0f)));
    }
}

