/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.rendering.scimaps;

import edu.iu.sci2.visualization.scimaps.MapOfScience;
import edu.iu.sci2.visualization.scimaps.rendering.scimaps.EdgeRenderer;
import edu.iu.sci2.visualization.scimaps.rendering.scimaps.NodeRenderer;
import edu.iu.sci2.visualization.scimaps.tempvis.GraphicsState;
import edu.iu.sci2.visualization.scimaps.tempvis.PageElement;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Line2D;
import java.util.Map;
import java.util.Set;
import oim.vivo.scimapcore.journal.Discipline;
import oim.vivo.scimapcore.journal.Disciplines;
import oim.vivo.scimapcore.journal.Edge;
import oim.vivo.scimapcore.journal.Node;
import oim.vivo.scimapcore.journal.Nodes;

public class MapOfScienceRenderer
implements PageElement {
    private MapOfScience mapOfScience;
    private float nodeScalingFactor;
    private double pageScalingFactor;
    private double leftBoundary;
    private double bottomBoundary;

    public MapOfScienceRenderer(MapOfScience mapOfScience, float nodeScalingFactor, double pageScalingFactor, double leftBoundary, double bottomBoundary) {
        this.mapOfScience = mapOfScience;
        this.nodeScalingFactor = nodeScalingFactor;
        this.pageScalingFactor = pageScalingFactor;
        this.leftBoundary = leftBoundary;
        this.bottomBoundary = bottomBoundary;
    }

    public static void render(GraphicsState state, MapOfScience mapOfScience, float scalingFactor) throws MapOfScienceRenderingException {
        state.setFontSize(6.0);
        MapOfScienceRenderer.renderLeftSide(state);
        MapOfScienceRenderer.renderRightSide(state);
        MapOfScienceRenderer.renderMapNodesAndEdges(state, mapOfScience, scalingFactor);
        MapOfScienceRenderer.renderDisciplineLabels(state);
    }

    private static void renderDisciplineLabel(GraphicsState state, String label, Discipline discipline, float x, float y) throws MapOfScienceRenderingException {
        if (discipline == null) {
            throw new MapOfScienceRenderingException("The category labeled '" + label + "' could not be located by id.  The underlying Map of Science might " + "have changed and the algorithm needs to be updated.");
        }
        MapOfScienceRenderer.renderDisciplineLabel(state, label, discipline.getColor(), x, y);
    }

    private static void renderDisciplineLabel(GraphicsState state, String label, Color color, float x, float y) {
        state.save();
        state.current.setColor(color);
        state.current.drawString(label, x, y);
        state.restore();
    }

    private static void renderDisciplineLabels(GraphicsState state) throws MapOfScienceRenderingException {
        state.save();
        state.setFontSize(8.0);
        state.current.translate(0.0, GraphicsState.inch(0.33f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Social Sciences", Disciplines.getDisciplineById((String)"13"), GraphicsState.inch(6.2f), GraphicsState.inch(-1.0f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Electrical Engineering", Disciplines.getDisciplineById((String)"7"), GraphicsState.inch(0.9f), GraphicsState.inch(-1.24f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "& Computer Science", Disciplines.getDisciplineById((String)"7"), GraphicsState.inch(0.9f), GraphicsState.inch(-1.12f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Biology", Disciplines.getDisciplineById((String)"1"), GraphicsState.inch(3.73f), GraphicsState.inch(-0.6f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Biotechnology", Disciplines.getDisciplineById((String)"2"), GraphicsState.inch(3.1f), GraphicsState.inch(-1.45f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Brain Research", Disciplines.getDisciplineById((String)"8"), GraphicsState.inch(5.63f), GraphicsState.inch(-1.23f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Medical Specialties", Disciplines.getDisciplineById((String)"3"), GraphicsState.inch(5.1f), GraphicsState.inch(-0.88f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Chemical, Mechanical, & Civil Engineering", Disciplines.getDisciplineById((String)"4"), GraphicsState.inch(2.08f), GraphicsState.inch(-1.1f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Chemistry", Disciplines.getDisciplineById((String)"5"), GraphicsState.inch(2.38f), GraphicsState.inch(-2.45f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Earth Sciences", Disciplines.getDisciplineById((String)"6"), GraphicsState.inch(2.65f), GraphicsState.inch(-0.4f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Health Professionals", Disciplines.getDisciplineById((String)"12"), GraphicsState.inch(5.3f), GraphicsState.inch(-2.55f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Humanities", Disciplines.getDisciplineById((String)"9"), GraphicsState.inch(6.18f), GraphicsState.inch(-0.4f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Infectious Disease", Disciplines.getDisciplineById((String)"10"), GraphicsState.inch(4.41f), GraphicsState.inch(-1.05f));
        MapOfScienceRenderer.renderDisciplineLabel(state, "Math & Physics", Disciplines.getDisciplineById((String)"11"), GraphicsState.inch(1.15f), GraphicsState.inch(-2.31f));
        state.restore();
    }

    private static void renderSideBar(GraphicsState state, String s) {
        state.save();
        state.setFontSize(7.0);
        state.setGray(0.3);
        FontMetrics metrics = state.current.getFontMetrics();
        float halfWidth = (float)metrics.stringWidth(s) / 2.0f;
        state.current.draw(new Line2D.Float(-(halfWidth + GraphicsState.inch(1.0f)), 2.0f, GraphicsState.inch(0.8f) - (halfWidth + GraphicsState.inch(1.0f)), 2.0f));
        state.current.drawString(s, -halfWidth, 3.5f);
        state.current.draw(new Line2D.Float(halfWidth + GraphicsState.inch(0.2f), 2.0f, halfWidth + GraphicsState.inch(0.2f) + GraphicsState.inch(0.8f), 2.0f));
        state.restore();
    }

    private static void renderMapNodesAndEdges(GraphicsState state, MapOfScience mapOfScience, float scalingFactor) {
        Set<Edge> edges = MapOfScience.getEdges();
        Map<Integer, Float> mapping = mapOfScience.getIdWeightMapping();
        state.save();
        state.current.translate(GraphicsState.inch(1.0f), GraphicsState.inch(0.3f));
        state.setGray(0.7);
        EdgeRenderer.renderEdges(state, edges);
        for (Integer id : mapOfScience.getMappedIdsByWeight()) {
            Node node = Nodes.getNodeByID((int)id);
            float weight = mapping.get(id).floatValue();
            NodeRenderer.render(state, node, weight, scalingFactor);
        }
        state.restore();
    }

    private static void renderRightSide(GraphicsState state) {
        state.save();
        state.current.translate(GraphicsState.inch(8.0f), GraphicsState.inch(-1.2f));
        state.current.rotate(1.5707963267948966);
        MapOfScienceRenderer.renderSideBar(state, "Map continued on left");
        state.restore();
    }

    private static void renderLeftSide(GraphicsState state) {
        state.save();
        state.current.translate(GraphicsState.inch(0.5f), GraphicsState.inch(-1.2f));
        state.current.rotate(-1.5707963267948966);
        MapOfScienceRenderer.renderSideBar(state, "Map continued on right");
        state.restore();
    }

    @Override
    public void render(GraphicsState state) throws PageElement.PageElementRenderingException {
        state.save();
        state.current.translate(this.leftBoundary, this.bottomBoundary);
        state.current.scale(this.pageScalingFactor, this.pageScalingFactor);
        try {
            try {
                MapOfScienceRenderer.render(state, this.mapOfScience, this.nodeScalingFactor);
            }
            catch (MapOfScienceRenderingException e) {
                throw new PageElement.PageElementRenderingException(e);
            }
        }
        finally {
            state.restore();
        }
    }

    public static class MapOfScienceRenderingException
    extends Exception {
        private static final long serialVersionUID = 7330170129647808546L;

        public MapOfScienceRenderingException(String message) {
            super(message);
        }
    }
}

