/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.rendering.simple;

import edu.iu.sci2.visualization.scimaps.MapOfScience;
import edu.iu.sci2.visualization.scimaps.rendering.AbstractRenderablePageManager;
import edu.iu.sci2.visualization.scimaps.rendering.CenteredCopyrightInfo;
import edu.iu.sci2.visualization.scimaps.rendering.CircleSizeLegend;
import edu.iu.sci2.visualization.scimaps.rendering.ItalicCenteredFooter;
import edu.iu.sci2.visualization.scimaps.rendering.PageLegend;
import edu.iu.sci2.visualization.scimaps.rendering.discipline_breakdown.DisciplineBreakdownArea;
import edu.iu.sci2.visualization.scimaps.rendering.discipline_breakdown.DisciplineBreakdownAreas;
import edu.iu.sci2.visualization.scimaps.rendering.scimaps.MapOfScienceRenderer;
import edu.iu.sci2.visualization.scimaps.tempvis.GraphicsState;
import java.awt.Dimension;
import java.util.Collections;

public class SimpleRenderablePageManager
extends AbstractRenderablePageManager {
    public SimpleRenderablePageManager(Dimension size, MapOfScience mapOfScience, float scalingFactor) {
        super(size, mapOfScience, scalingFactor);
        this.addPageIndependentElements();
        this.addPageDependentElements();
    }

    @Override
    protected void addPageIndependentElements() {
        this.addToAllPages(new ItalicCenteredFooter(this.dimensions.getWidth() / 2.0, this.dimensions.getHeight() - (double)GraphicsState.inch(0.25f)));
    }

    @Override
    protected void addPageDependentElements() {
        int currentPage = 0;
        this.addMapOfSciencePage(currentPage);
        ++currentPage;
        Dimension breakdownAreaSize = new Dimension(1100, 800);
        for (DisciplineBreakdownArea breakdownArea : DisciplineBreakdownAreas.getDisciplineBreakdownAreas(breakdownAreaSize, 2, this.mapOfScience, GraphicsState.inch(0.25f), 100.0)) {
            this.addToPage(currentPage, breakdownArea);
            ++currentPage;
        }
    }

    @Override
    protected void addMapOfSciencePage(int pageNumber) {
        float pageScalingFactor = 2.1f;
        this.addToPage(pageNumber, new CenteredCopyrightInfo((float)this.dimensions.getWidth() / 2.0f, GraphicsState.inch(8.66f), 16));
        this.addToPage(pageNumber, new CircleSizeLegend(this.scalingFactor, pageScalingFactor, GraphicsState.inch(4.96f), GraphicsState.inch(11.0f), 16, 20, 5.0f, 100.0f));
        this.addToPage(pageNumber, new PageLegend(this.mapOfScience.getDataColumnName(), (int)this.mapOfScience.countOfUnmappedPublications(), Collections.min(this.mapOfScience.getMappedWeights()).floatValue(), Collections.max(this.mapOfScience.getMappedWeights()).floatValue(), GraphicsState.inch(0.25f), GraphicsState.inch(11.0f), 20, 16));
        this.addToPage(pageNumber, new MapOfScienceRenderer(this.mapOfScience, this.scalingFactor, pageScalingFactor, 25.0, 500.0));
    }
}

