/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.tempvis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import edu.iu.sci2.visualization.scimaps.tempvis.GraphicsState;
import edu.iu.sci2.visualization.scimaps.tempvis.PageElement;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractPageManager {
    private final Multimap<Integer, PageElement> pageSpecificElements = HashMultimap.create();
    private final Set<PageElement> pageIndependentElements = new HashSet<PageElement>();
    protected final Dimension dimensions;

    protected AbstractPageManager(Dimension dimensions) {
        this.dimensions = dimensions;
    }

    protected void addToPage(int pageNumber, PageElement pageElement) {
        this.pageSpecificElements.put((Object)pageNumber, (Object)pageElement);
    }

    protected void addToAllPages(PageElement pageElement) {
        this.pageIndependentElements.add(pageElement);
    }

    public void render(int pageNumber, GraphicsState state) throws PageManagerRenderingException {
        if (!this.pageSpecificElements.isEmpty() && this.pageSpecificElements.get((Object)pageNumber).isEmpty()) {
            return;
        }
        if (pageNumber != 1 && this.pageSpecificElements.isEmpty()) {
            throw new PageManagerRenderingException("Page number '" + pageNumber + "' does not exist");
        }
        ArrayList<PageElement.PageElementRenderingException> exceptions = new ArrayList<PageElement.PageElementRenderingException>();
        for (PageElement element : this.pageIndependentElements) {
            try {
                element.render(state);
            }
            catch (PageElement.PageElementRenderingException e) {
                exceptions.add(e);
            }
        }
        for (PageElement element : this.pageSpecificElements.get((Object)pageNumber)) {
            try {
                element.render(state);
            }
            catch (PageElement.PageElementRenderingException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            String newline = System.getProperty("line.separator");
            String message = "The following exceptions occured when rendering.  The cause of the first is also passed up." + newline;
            for (PageElement.PageElementRenderingException e : exceptions) {
                message = String.valueOf(message) + e.getMessage() + newline;
            }
            throw new PageManagerRenderingException(message, (Throwable)exceptions.get(0));
        }
    }

    public int numberOfPages() {
        if (this.pageIndependentElements.isEmpty() && this.pageSpecificElements.isEmpty()) {
            return 0;
        }
        if (this.pageSpecificElements.isEmpty() && !this.pageIndependentElements.isEmpty()) {
            return 1;
        }
        return this.pageSpecificElements.keySet().size();
    }

    public Dimension pageDimensions() {
        return this.dimensions;
    }

    public static class PageManagerRenderingException
    extends Exception {
        private static final long serialVersionUID = -3602350657917186922L;

        public PageManagerRenderingException() {
        }

        public PageManagerRenderingException(String message) {
            super(message);
        }

        public PageManagerRenderingException(Throwable cause) {
            super(cause);
        }

        public PageManagerRenderingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

