/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.tempvis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Stack;

public class GraphicsState {
    public static final float POINTS_PER_INCH = 72.0f;
    public Graphics2D current;
    private Stack<Graphics2D> graphicsHistory = new Stack();

    public GraphicsState(Graphics2D graphics) {
        this.current = graphics;
        this.graphicsHistory = new Stack();
    }

    public void save() {
        this.graphicsHistory.push(this.current);
        this.current = (Graphics2D)this.current.create();
    }

    public void restore() {
        if (!this.graphicsHistory.isEmpty()) {
            this.current.dispose();
            this.current = this.graphicsHistory.pop();
        }
    }

    public int stringWidth(String s) {
        return this.current.getFontMetrics().stringWidth(s);
    }

    public void scaleFont(double scale) {
        this.setFontSize((double)this.current.getFont().getSize() * scale);
    }

    public void setFontSize(double fontSize) {
        this.current.setFont(this.current.getFont().deriveFont((float)fontSize));
    }

    public void setFont(String fontName) {
        this.current.setFont(Font.getFont(fontName));
    }

    public void setFont(String fontName, int style, int fontSize) {
        this.current.setFont(new Font(fontName, style, fontSize));
    }

    public void setFont(String fontName, int fontSize) {
        this.setFont(fontName, 0, fontSize);
    }

    public void setBoldFont(String fontName, int fontSize) {
        this.setFont(fontName, 1, fontSize);
    }

    public void setItalicFont(String fontName, int fontSize) {
        this.setFont(fontName, 2, fontSize);
    }

    public void setGray(double gray) {
        this.current.setColor(new Color((float)gray, (float)gray, (float)gray));
    }

    public void drawArc(int centerX, int centerY, int radius, int startAngle, int arcAngle) {
        this.drawArc(centerX, centerY, radius, startAngle, arcAngle, 1.0f);
    }

    public void drawStringAndTranslate(String string, float x, float y) {
        this.current.drawString(string, x, y);
        this.current.translate(0, this.current.getFontMetrics().getHeight());
    }

    public void drawStringAndTranslate(String string, int x, int y) {
        this.current.drawString(string, x, y);
        this.current.translate(0, this.current.getFontMetrics().getHeight());
    }

    public void drawStringAndTranslate(String string) {
        this.drawStringAndTranslate(string, 0, 0);
    }

    public static float inch(float points) {
        return 72.0f * points;
    }

    public void drawCircle(int centerX, int centerY, int radius) {
        this.drawArc(centerX, centerY, radius, 0, 360);
    }

    public void drawCircle(int centerX, int centerY, int radius, int weight) {
        this.drawArc(centerX, centerY, radius, 0, 360, weight);
    }

    private void drawArc(int centerX, int centerY, int radius, int startAngle, int arcAngle, float weight) {
        int upperLeftX = centerX - radius;
        int upperLeftY = centerY - radius;
        int width = 2 * radius;
        int height = 2 * radius;
        this.save();
        this.current.setStroke(new BasicStroke(weight));
        this.current.drawArc(upperLeftX, upperLeftY, width, height, startAngle, arcAngle);
        this.restore();
    }
}

